/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UISelectMany;
import jakarta.faces.component.UISelectOne;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.shared.renderkit.html.CommonEventUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HTML;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.SelectItemInfo;
import org.apache.myfaces.shared.renderkit.html.util.SelectItemsUtils;

public class HtmlSelectableRendererBase
extends HtmlRenderer {
    protected void internalRenderSelect(FacesContext facesContext, UIComponent uiComponent, boolean disabled, int size, boolean selectMany, Converter converter) throws IOException {
        List<SelectItemInfo> selectItemList;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("select", uiComponent);
        if (uiComponent instanceof ClientBehaviorHolder && !((ClientBehaviorHolder)((Object)uiComponent)).getClientBehaviors().isEmpty()) {
            writer.writeAttribute("id", uiComponent.getClientId(facesContext), null);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        }
        writer.writeAttribute("name", uiComponent.getClientId(facesContext), null);
        if (selectMany) {
            writer.writeAttribute("multiple", "multiple", null);
            selectItemList = SelectItemsUtils.getSelectItemInfoList((UISelectMany)uiComponent, facesContext);
        } else {
            selectItemList = SelectItemsUtils.getSelectItemInfoList((UISelectOne)uiComponent, facesContext);
        }
        if (size == Integer.MIN_VALUE) {
            writer.writeAttribute("size", Integer.toString(selectItemList.size()), null);
        } else {
            writer.writeAttribute("size", Integer.toString(size), null);
        }
        Map<String, List<ClientBehavior>> behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)((Object)uiComponent)).getClientBehaviors();
            long commonPropertiesMarked = 0L;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(uiComponent);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderChangeEventProperty(writer, commonPropertiesMarked, uiComponent);
                CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, uiComponent);
                CommonPropertyUtils.renderFieldEventPropertiesWithoutOnchangeAndOnselect(writer, commonPropertiesMarked, uiComponent);
            } else {
                HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, uiComponent, behaviors);
                if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(uiComponent);
                    CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, behaviors);
                    CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, uiComponent, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, uiComponent, behaviors);
                }
            }
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderSelectPassthroughPropertiesWithoutDisabledAndEvents(writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), uiComponent);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
            }
        } else if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            CommonPropertyUtils.renderSelectPassthroughPropertiesWithoutDisabled(writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), uiComponent);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        }
        if (disabled) {
            writer.writeAttribute("disabled", "disabled", null);
        }
        if (HtmlRendererUtils.isReadOnly(uiComponent)) {
            writer.writeAttribute("readonly", "readonly", null);
        }
        Set lookupSet = HtmlRendererUtils.getSubmittedOrSelectedValuesAsSet(selectMany, uiComponent, facesContext, converter);
        SelectItemsUtils.renderSelectOptions(facesContext, uiComponent, converter, lookupSet, selectItemList);
        writer.writeText("", null);
        writer.endElement("select");
    }
}

