/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.ui;

import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagHandler;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.el.VariableMapperWrapper;
import org.apache.myfaces.view.facelets.impl.TemplateContextImpl;
import org.apache.myfaces.view.facelets.tag.ComponentContainerHandler;
import org.apache.myfaces.view.facelets.tag.TagHandlerUtils;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.ui.ParamHandler;

public final class IncludeHandler
extends TagHandler
implements ComponentContainerHandler {
    private static final String ERROR_PAGE_INCLUDE_PATH = "jakarta.faces.error.xhtml";
    private static final String ERROR_FACELET = "META-INF/rsc/myfaces-dev-error-include.xhtml";
    private final TagAttribute src = this.getRequiredAttribute("src");
    private final ParamHandler[] _params;

    public IncludeHandler(TagConfig config) {
        super(config);
        Collection<ParamHandler> params = TagHandlerUtils.findNextByType(this.nextHandler, ParamHandler.class);
        if (!params.isEmpty()) {
            int i = 0;
            this._params = new ParamHandler[params.size()];
            for (ParamHandler handler : params) {
                this._params[i++] = handler;
            }
        } else {
            this._params = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        String path;
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        FaceletCompositionContext fcc = FaceletCompositionContext.getCurrentInstance(ctx);
        boolean markInitialState = false;
        String uniqueId = null;
        if (!this.src.isLiteral()) {
            uniqueId = actx.generateUniqueFaceletTagId(fcc.startComponentUniqueIdSection(), this.tagId);
        } else if (this._params != null) {
            uniqueId = actx.generateUniqueFaceletTagId(fcc.generateUniqueComponentId(), this.tagId);
        }
        if (!this.src.isLiteral()) {
            String restoredPath = (String)ComponentSupport.restoreInitialTagState(ctx, fcc, parent, uniqueId);
            if (restoredPath != null) {
                if (!PhaseId.RESTORE_VIEW.equals(ctx.getFacesContext().getCurrentPhaseId())) {
                    path = this.src.getValue(ctx);
                    if (path == null || path.length() == 0) {
                        return;
                    }
                    if (!path.equals(restoredPath)) {
                        markInitialState = true;
                    }
                } else {
                    path = restoredPath;
                }
            } else {
                path = this.src.getValue(ctx);
            }
            ComponentSupport.saveInitialTagState(ctx, fcc, parent, uniqueId, path);
        } else {
            path = this.src.getValue(ctx);
        }
        try {
            if (path == null || path.length() == 0) {
                return;
            }
            VariableMapper orig = ctx.getVariableMapper();
            ctx.setVariableMapper(new VariableMapperWrapper(orig));
            try {
                block35: {
                    boolean oldMarkInitialState;
                    block38: {
                        Boolean isBuildingInitialState;
                        block36: {
                            URL url = null;
                            oldMarkInitialState = false;
                            isBuildingInitialState = null;
                            if (ctx.getFacesContext().isProjectStage(ProjectStage.Development) && ERROR_PAGE_INCLUDE_PATH.equals(path)) {
                                url = ClassUtils.getResource(ERROR_FACELET);
                            }
                            if (markInitialState) {
                                oldMarkInitialState = fcc.isMarkInitialState();
                                fcc.setMarkInitialState(true);
                                isBuildingInitialState = (Boolean)ctx.getFacesContext().getAttributes().put("jakarta.faces.IS_BUILDING_INITIAL_STATE", Boolean.TRUE);
                            }
                            try {
                                if (this._params != null) {
                                    int i;
                                    String[] names = new String[this._params.length];
                                    ValueExpression[] values = new ValueExpression[this._params.length];
                                    for (i = 0; i < this._params.length; ++i) {
                                        names[i] = this._params[i].getName(ctx);
                                        values[i] = this._params[i].getValue(ctx);
                                    }
                                    actx.pushTemplateContext(new TemplateContextImpl());
                                    for (i = 0; i < this._params.length; ++i) {
                                        this._params[i].apply(ctx, parent, names[i], values[i], uniqueId);
                                    }
                                } else {
                                    actx.pushTemplateContext(new TemplateContextImpl());
                                }
                                if (url == null) {
                                    ctx.includeFacelet(parent, path);
                                } else {
                                    ctx.includeFacelet(parent, url);
                                }
                                if (!markInitialState) break block35;
                                if (isBuildingInitialState != null) break block36;
                                ctx.getFacesContext().getAttributes().remove("jakarta.faces.IS_BUILDING_INITIAL_STATE");
                            }
                            catch (Throwable throwable) {
                                if (markInitialState) {
                                    if (isBuildingInitialState == null) {
                                        ctx.getFacesContext().getAttributes().remove("jakarta.faces.IS_BUILDING_INITIAL_STATE");
                                    } else {
                                        ctx.getFacesContext().getAttributes().put("jakarta.faces.IS_BUILDING_INITIAL_STATE", isBuildingInitialState);
                                    }
                                    fcc.setMarkInitialState(oldMarkInitialState);
                                }
                                actx.popTemplateContext();
                                throw throwable;
                            }
                            break block38;
                        }
                        ctx.getFacesContext().getAttributes().put("jakarta.faces.IS_BUILDING_INITIAL_STATE", isBuildingInitialState);
                    }
                    fcc.setMarkInitialState(oldMarkInitialState);
                }
                actx.popTemplateContext();
            }
            finally {
                ctx.setVariableMapper(orig);
            }
        }
        finally {
            if (!this.src.isLiteral()) {
                fcc.endComponentUniqueIdSection();
                if (fcc.isUsingPSSOnThisView() && fcc.isRefreshTransientBuildOnPSS() && !fcc.isRefreshingTransientBuild()) {
                    ComponentSupport.markComponentToRestoreFully(ctx.getFacesContext(), parent);
                }
                if (fcc.isDynamicComponentSection()) {
                    ComponentSupport.markComponentToRefreshDynamically(ctx.getFacesContext(), parent);
                }
            }
        }
    }
}

