/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.el.ValueExpression;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UISelectItem;
import jakarta.faces.component.UISelectItems;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component._EmptyIterator;
import jakarta.faces.context.FacesContext;
import jakarta.faces.model.SelectItem;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

class _SelectItemsIterator
implements Iterator<SelectItem> {
    private static final Logger log = Logger.getLogger(_SelectItemsIterator.class.getName());
    private static final Iterator<UIComponent> _EMPTY_UICOMPONENT_ITERATOR = new _EmptyIterator<UIComponent>();
    private static final String VAR_ATTR = "var";
    private static final String ITEM_VALUE_ATTR = "itemValue";
    private static final String ITEM_LABEL_ATTR = "itemLabel";
    private static final String ITEM_DESCRIPTION_ATTR = "itemDescription";
    private static final String ITEM_DISABLED_ATTR = "itemDisabled";
    private static final String ITEM_LABEL_ESCAPED_ATTR = "itemLabelEscaped";
    private static final String NO_SELECTION_VALUE_ATTR = "noSelectionValue";
    private final Iterator<UIComponent> _children;
    private Iterator<?> _nestedItems;
    private SelectItem _nextItem;
    private UIComponent _currentComponent;
    private UISelectItems _currentUISelectItems;
    private FacesContext _facesContext;

    public _SelectItemsIterator(UIComponent selectItemsParent, FacesContext facesContext) {
        this._children = selectItemsParent.getChildCount() > 0 ? selectItemsParent.getChildren().iterator() : _EMPTY_UICOMPONENT_ITERATOR;
        this._facesContext = facesContext;
    }

    @Override
    public boolean hasNext() {
        if (this._nextItem != null) {
            return true;
        }
        if (this._nestedItems != null) {
            if (this._nestedItems.hasNext()) {
                return true;
            }
            this._nestedItems = null;
            this._currentComponent = null;
        }
        if (this._children.hasNext()) {
            UIComponent child = this._children.next();
            while (!(child instanceof UISelectItem) && !(child instanceof UISelectItems)) {
                if (this._children.hasNext()) {
                    child = this._children.next();
                    continue;
                }
                return false;
            }
            if (child instanceof UISelectItem) {
                UISelectItem uiSelectItem = (UISelectItem)child;
                Object item = uiSelectItem.getValue();
                if (item == null) {
                    Object itemValue = uiSelectItem.getItemValue();
                    String label = uiSelectItem.getItemLabel();
                    String description = uiSelectItem.getItemDescription();
                    boolean disabled = uiSelectItem.isItemDisabled();
                    boolean escape = uiSelectItem.isItemEscaped();
                    boolean noSelectionOption = uiSelectItem.isNoSelectionOption();
                    if (label == null && itemValue != null) {
                        label = itemValue.toString();
                    }
                    item = new SelectItem(itemValue, label, description, disabled, escape, noSelectionOption);
                } else if (!(item instanceof SelectItem)) {
                    ValueExpression expression = uiSelectItem.getValueExpression("value");
                    throw new IllegalArgumentException("ValueExpression '" + (expression == null ? null : expression.getExpressionString()) + "' of UISelectItem : " + this.getPathToComponent(child) + " does not reference an Object of type SelectItem");
                }
                this._nextItem = (SelectItem)item;
                this._currentComponent = child;
                return true;
            }
            if (child instanceof UISelectItems) {
                this._currentUISelectItems = (UISelectItems)child;
                Object value = this._currentUISelectItems.getValue();
                this._currentComponent = child;
                if (value instanceof SelectItem) {
                    this._nextItem = (SelectItem)value;
                    return true;
                }
                if (value != null && value.getClass().isArray()) {
                    int length = Array.getLength(value);
                    ArrayList<Object> items = new ArrayList<Object>(length);
                    for (int i = 0; i < length; ++i) {
                        items.add(Array.get(value, i));
                    }
                    this._nestedItems = items.iterator();
                    return this.hasNext();
                }
                if (value instanceof Iterable) {
                    this._nestedItems = ((Iterable)value).iterator();
                    return this.hasNext();
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    ArrayList<SelectItem> items = new ArrayList<SelectItem>(map.size());
                    for (Map.Entry entry : map.entrySet()) {
                        items.add(new SelectItem(entry.getValue(), entry.getKey().toString()));
                    }
                    this._nestedItems = items.iterator();
                    return this.hasNext();
                }
                Level level = Level.FINE;
                if (!this._facesContext.isProjectStage(ProjectStage.Production)) {
                    level = Level.WARNING;
                }
                if (log.isLoggable(level)) {
                    ValueExpression expression = this._currentUISelectItems.getValueExpression("value");
                    log.log(level, "ValueExpression {0} of UISelectItems with component-path {1} does not reference an Object of type SelectItem, array, Iterable or Map, but of type: {2}", new Object[]{expression == null ? null : expression.getExpressionString(), this.getPathToComponent(child), value == null ? null : value.getClass().getName()});
                }
            } else {
                this._currentComponent = null;
            }
        }
        return false;
    }

    @Override
    public SelectItem next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this._nextItem != null) {
            SelectItem value = this._nextItem;
            this._nextItem = null;
            return value;
        }
        if (this._nestedItems != null) {
            Object item = this._nestedItems.next();
            if (!(item instanceof SelectItem)) {
                Object itemDescription;
                Object itemLabel;
                Object itemValue;
                Map<String, Object> attributeMap = this._currentUISelectItems.getAttributes();
                boolean wroteRequestMapVarValue = false;
                Object oldRequestMapVarValue = null;
                String var = (String)attributeMap.get(VAR_ATTR);
                if (var != null && !"".equals(var)) {
                    oldRequestMapVarValue = this._facesContext.getExternalContext().getRequestMap().put(var, item);
                    wroteRequestMapVarValue = true;
                }
                if ((itemValue = attributeMap.get(ITEM_VALUE_ATTR)) == null) {
                    itemValue = item;
                }
                if ((itemLabel = attributeMap.get(ITEM_LABEL_ATTR)) == null) {
                    if (itemValue != null) {
                        itemLabel = itemValue.toString();
                    }
                } else {
                    itemLabel = itemLabel.toString();
                }
                if ((itemDescription = attributeMap.get(ITEM_DESCRIPTION_ATTR)) != null) {
                    itemDescription = itemDescription.toString();
                }
                Boolean itemDisabled = this.getBooleanAttribute(this._currentUISelectItems, ITEM_DISABLED_ATTR, false);
                Boolean itemLabelEscaped = this.getBooleanAttribute(this._currentUISelectItems, ITEM_LABEL_ESCAPED_ATTR, true);
                Object noSelectionValue = attributeMap.get(NO_SELECTION_VALUE_ATTR);
                item = new SelectItem(itemValue, (String)itemLabel, (String)itemDescription, itemDisabled, itemLabelEscaped, itemValue.equals(noSelectionValue));
                if (wroteRequestMapVarValue) {
                    if (oldRequestMapVarValue != null) {
                        this._facesContext.getExternalContext().getRequestMap().put(var, oldRequestMapVarValue);
                    } else {
                        this._facesContext.getExternalContext().getRequestMap().remove(var);
                    }
                }
            }
            return (SelectItem)item;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public UIComponent getCurrentComponent() {
        return this._currentComponent;
    }

    private boolean getBooleanAttribute(UIComponent component, String attrName, boolean defaultValue) {
        Object value = component.getAttributes().get(attrName);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }

    private String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        this.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, intBuf);
        this.getPathToComponent(component.getParent(), buf);
    }
}

