/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.util;

import jakarta.faces.context.ExternalContext;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.myfaces.config.util.JarUtils;
import org.apache.myfaces.shared.util.StringUtils;

public class GAEUtils {
    public static final String WEB_LIB_PREFIX = "/WEB-INF/lib/";

    public static Collection<URL> searchInWebLib(ExternalContext context, ClassLoader classloader, String filter, String prefix, String suffix) throws IOException {
        if (!filter.equals("none")) {
            String[] jarFilesToScan = StringUtils.trim(StringUtils.splitLongString(filter, ','));
            TreeSet<URL> urlSet = null;
            Set paths = context.getResourcePaths(WEB_LIB_PREFIX);
            if (paths != null) {
                for (Object pathObject : paths) {
                    String path = (String)pathObject;
                    if (!path.endsWith(".jar") || !GAEUtils.wildcardMatch(path, jarFilesToScan, WEB_LIB_PREFIX)) continue;
                    URL jarUrl = new URL("jar:" + context.getResource(path).toExternalForm() + "!/");
                    JarFile jarFile = JarUtils.getJarFile(jarUrl);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        String name;
                        JarEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !(name = entry.getName()).startsWith(prefix) || !name.endsWith(suffix)) continue;
                        Enumeration<URL> alternateFacesConfigs = classloader.getResources(name);
                        while (alternateFacesConfigs.hasMoreElements()) {
                            if (urlSet == null) {
                                urlSet = new TreeSet<URL>();
                            }
                            urlSet.add(alternateFacesConfigs.nextElement());
                        }
                    }
                }
            }
            return urlSet;
        }
        return null;
    }

    public static boolean wildcardMatch(String filename, String[] wildcardMatchers, String prefix) {
        for (String matcher : wildcardMatchers) {
            if (!GAEUtils.wildcardMatch(filename, prefix + matcher)) continue;
            return true;
        }
        return false;
    }

    static boolean wildcardMatch(String filename, String wildcardMatcher) {
        return GAEUtils.wildcardMatch(filename, wildcardMatcher, IOCase.SENSITIVE);
    }

    static boolean wildcardMatchOnSystem(String filename, String wildcardMatcher) {
        return GAEUtils.wildcardMatch(filename, wildcardMatcher, IOCase.SENSITIVE);
    }

    static boolean wildcardMatch(String filename, String wildcardMatcher, IOCase caseSensitivity) {
        if (filename == null && wildcardMatcher == null) {
            return true;
        }
        if (filename == null || wildcardMatcher == null) {
            return false;
        }
        if (caseSensitivity == null) {
            caseSensitivity = IOCase.SENSITIVE;
        }
        String[] wcs = GAEUtils.splitOnTokens(wildcardMatcher);
        boolean anyChars = false;
        int textIdx = 0;
        int wcsIdx = 0;
        Stack<int[]> backtrack = new Stack<int[]>();
        do {
            if (backtrack.size() > 0) {
                int[] array = (int[])backtrack.pop();
                wcsIdx = array[0];
                textIdx = array[1];
                anyChars = true;
            }
            while (wcsIdx < wcs.length) {
                if (wcs[wcsIdx].equals("?")) {
                    if (++textIdx > filename.length()) break;
                    anyChars = false;
                } else if (wcs[wcsIdx].equals("*")) {
                    anyChars = true;
                    if (wcsIdx == wcs.length - 1) {
                        textIdx = filename.length();
                    }
                } else {
                    if (anyChars) {
                        if ((textIdx = caseSensitivity.checkIndexOf(filename, textIdx, wcs[wcsIdx])) == -1) break;
                        int repeat = caseSensitivity.checkIndexOf(filename, textIdx + 1, wcs[wcsIdx]);
                        if (repeat >= 0) {
                            backtrack.push(new int[]{wcsIdx, repeat});
                        }
                    } else if (!caseSensitivity.checkRegionMatches(filename, textIdx, wcs[wcsIdx])) break;
                    textIdx += wcs[wcsIdx].length();
                    anyChars = false;
                }
                ++wcsIdx;
            }
            if (wcsIdx != wcs.length || textIdx != filename.length()) continue;
            return true;
        } while (backtrack.size() > 0);
        return false;
    }

    static String[] splitOnTokens(String text) {
        if (text.indexOf(63) == -1 && text.indexOf(42) == -1) {
            return new String[]{text};
        }
        char[] array = text.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == '?' || array[i] == '*') {
                if (buffer.length() != 0) {
                    list.add(buffer.toString());
                    buffer.setLength(0);
                }
                if (array[i] == '?') {
                    list.add("?");
                    continue;
                }
                if (!list.isEmpty() && (i <= 0 || ((String)list.get(list.size() - 1)).equals("*"))) continue;
                list.add("*");
                continue;
            }
            buffer.append(array[i]);
        }
        if (buffer.length() != 0) {
            list.add(buffer.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    static final class IOCase
    implements Serializable {
        public static final IOCase SENSITIVE = new IOCase("Sensitive", true);
        public static final IOCase INSENSITIVE = new IOCase("Insensitive", false);
        private static final long serialVersionUID = -6343169151696340687L;
        private final String name;
        private final transient boolean sensitive;

        public static IOCase forName(String name) {
            if (IOCase.SENSITIVE.name.equals(name)) {
                return SENSITIVE;
            }
            if (IOCase.INSENSITIVE.name.equals(name)) {
                return INSENSITIVE;
            }
            throw new IllegalArgumentException("Invalid IOCase name: " + name);
        }

        private IOCase(String name, boolean sensitive) {
            this.name = name;
            this.sensitive = sensitive;
        }

        private Object readResolve() {
            return IOCase.forName(this.name);
        }

        public String getName() {
            return this.name;
        }

        public boolean isCaseSensitive() {
            return this.sensitive;
        }

        public int checkCompareTo(String str1, String str2) {
            if (str1 == null || str2 == null) {
                throw new NullPointerException("The strings must not be null");
            }
            return this.sensitive ? str1.compareTo(str2) : str1.compareToIgnoreCase(str2);
        }

        public boolean checkEquals(String str1, String str2) {
            if (str1 == null || str2 == null) {
                throw new NullPointerException("The strings must not be null");
            }
            return this.sensitive ? str1.equals(str2) : str1.equalsIgnoreCase(str2);
        }

        public boolean checkStartsWith(String str, String start) {
            return str.regionMatches(!this.sensitive, 0, start, 0, start.length());
        }

        public boolean checkEndsWith(String str, String end) {
            int endLen = end.length();
            return str.regionMatches(!this.sensitive, str.length() - endLen, end, 0, endLen);
        }

        public int checkIndexOf(String str, int strStartIndex, String search) {
            int endIndex = str.length() - search.length();
            if (endIndex >= strStartIndex) {
                for (int i = strStartIndex; i <= endIndex; ++i) {
                    if (!this.checkRegionMatches(str, i, search)) continue;
                    return i;
                }
            }
            return -1;
        }

        public boolean checkRegionMatches(String str, int strStartIndex, String search) {
            return str.regionMatches(!this.sensitive, strStartIndex, search, 0, search.length());
        }

        public String toString() {
            return this.name;
        }
    }
}

