/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.jsp;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.myfaces.shared.view.ViewResponseWrapper;

public class ServletViewResponseWrapper
extends HttpServletResponseWrapper
implements ViewResponseWrapper {
    private PrintWriter _writer;
    private CharArrayWriter _charArrayWriter;
    private int _status = 200;
    private WrappedServletOutputStream _byteArrayWriter;

    public ServletViewResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public void sendError(int status) throws IOException {
        super.sendError(status);
        this._status = status;
    }

    public void sendError(int status, String errorMessage) throws IOException {
        super.sendError(status, errorMessage);
        this._status = status;
    }

    public void setStatus(int status) {
        super.setStatus(status);
        this._status = status;
    }

    public void setStatus(int status, String errorMessage) {
        super.setStatus(status, errorMessage);
        this._status = status;
    }

    public int getStatus() {
        return this._status;
    }

    public void flushToWrappedResponse() throws IOException {
        if (this._charArrayWriter != null) {
            this._charArrayWriter.writeTo(this.getResponse().getWriter());
            this._charArrayWriter.reset();
            this._writer.flush();
        } else if (this._byteArrayWriter != null) {
            try {
                this._byteArrayWriter.writeTo(this.getResponse().getWriter(), this.getResponse().getCharacterEncoding());
            }
            catch (IllegalStateException e) {
                this.getResponse().getOutputStream().write(this._byteArrayWriter.toByteArray());
            }
            this._byteArrayWriter.reset();
            this._byteArrayWriter.flush();
        }
    }

    @Override
    public void flushToWriter(Writer writer, String encoding) throws IOException {
        if (this._charArrayWriter != null) {
            this._charArrayWriter.writeTo(writer);
            this._charArrayWriter.reset();
            this._writer.flush();
        } else if (this._byteArrayWriter != null) {
            this._byteArrayWriter.writeTo(writer, encoding);
            this._byteArrayWriter.reset();
            this._byteArrayWriter.flush();
        }
        writer.flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._charArrayWriter != null) {
            throw new IllegalStateException();
        }
        if (this._byteArrayWriter == null) {
            this._byteArrayWriter = new WrappedServletOutputStream();
        }
        return this._byteArrayWriter;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._byteArrayWriter != null) {
            throw new IllegalStateException();
        }
        if (this._writer == null) {
            this._charArrayWriter = new CharArrayWriter(4096);
            this._writer = new PrintWriter(this._charArrayWriter);
        }
        return this._writer;
    }

    public void reset() {
        if (this._charArrayWriter != null) {
            this._charArrayWriter.reset();
        }
    }

    public String toString() {
        if (this._charArrayWriter != null) {
            return this._charArrayWriter.toString();
        }
        return null;
    }

    static class WrappedServletOutputStream
    extends ServletOutputStream {
        private WrappedByteArrayOutputStream _byteArrayOutputStream = new WrappedByteArrayOutputStream(1024);

        public void write(int i) throws IOException {
            this._byteArrayOutputStream.write(i);
        }

        public byte[] toByteArray() {
            return this._byteArrayOutputStream.toByteArray();
        }

        private void writeTo(Writer out, String encoding) throws IOException {
            Charset charset = encoding == null ? Charset.defaultCharset() : Charset.forName(encoding);
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer decodedBuffer = decoder.decode(ByteBuffer.wrap(this._byteArrayOutputStream.getInnerArray(), 0, this._byteArrayOutputStream.getInnerCount()));
            if (decodedBuffer.hasArray()) {
                out.write(decodedBuffer.array());
            }
        }

        public void reset() {
            this._byteArrayOutputStream.reset();
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener wl) {
        }

        static class WrappedByteArrayOutputStream
        extends ByteArrayOutputStream {
            public WrappedByteArrayOutputStream() {
            }

            public WrappedByteArrayOutputStream(int size) {
                super(size);
            }

            private byte[] getInnerArray() {
                return this.buf;
            }

            private int getInnerCount() {
                return this.count;
            }
        }
    }
}

