/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Entities;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Graphic;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.html.HtmlTagMap;
import com.lowagie.text.pdf.BaseFont;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SAXiTextHandler
extends DefaultHandler {
    protected DocListener document;
    protected Stack stack;
    protected int chapters = 0;
    protected Chunk currentChunk = null;
    protected boolean ignore = false;
    protected boolean controlOpenClose = true;
    float topMargin = 36.0f;
    float rightMargin = 36.0f;
    float leftMargin = 36.0f;
    float bottomMargin = 36.0f;
    protected HashMap myTags;
    private BaseFont bf = null;
    static /* synthetic */ Class class$0;

    public SAXiTextHandler(DocListener document) {
        this.document = document;
        this.stack = new Stack();
    }

    public SAXiTextHandler(DocListener document, HtmlTagMap myTags) {
        this(document);
        this.myTags = myTags;
    }

    public SAXiTextHandler(DocListener document, HtmlTagMap myTags, BaseFont bf) {
        this(document, myTags);
        this.bf = bf;
    }

    public SAXiTextHandler(DocListener document, HashMap myTags) {
        this(document);
        this.myTags = myTags;
    }

    public void setControlOpenClose(boolean controlOpenClose) {
        this.controlOpenClose = controlOpenClose;
    }

    public void startElement(String uri, String lname, String name, Attributes attrs) {
        Properties attributes = new Properties();
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                String attribute = attrs.getQName(i);
                attributes.setProperty(attribute, attrs.getValue(i));
                ++i;
            }
        }
        this.handleStartingTags(name, attributes);
    }

    public void handleStartingTags(String name, Properties attributes) {
        TextElementArray current;
        if (this.ignore || "ignore".equals(name)) {
            this.ignore = true;
            return;
        }
        if (this.currentChunk != null) {
            try {
                current = (TextElementArray)this.stack.pop();
            }
            catch (EmptyStackException ese) {
                current = this.bf == null ? new Paragraph("", new Font()) : new Paragraph("", new Font(this.bf));
            }
            current.add(this.currentChunk);
            this.stack.push(current);
            this.currentChunk = null;
        }
        if (Chunk.isTag(name)) {
            this.currentChunk = new Chunk(attributes);
            if (this.bf != null) {
                this.currentChunk.setFont(new Font(this.bf));
            }
            return;
        }
        if (Entities.isTag(name)) {
            Font f = new Font();
            if (this.currentChunk != null) {
                this.handleEndingTags("chunk");
                f = this.currentChunk.font();
            }
            this.currentChunk = Entities.get(attributes.getProperty("id"), f);
            return;
        }
        if (Phrase.isTag(name)) {
            this.stack.push(new Phrase(attributes));
            return;
        }
        if (Anchor.isTag(name)) {
            this.stack.push(new Anchor(attributes));
            return;
        }
        if (Paragraph.isTag(name) || Section.isTitle(name)) {
            this.stack.push(new Paragraph(attributes));
            return;
        }
        if (List.isTag(name)) {
            this.stack.push(new List(attributes));
            return;
        }
        if (ListItem.isTag(name)) {
            this.stack.push(new ListItem(attributes));
            return;
        }
        if (Cell.isTag(name)) {
            this.stack.push(new Cell(attributes));
            return;
        }
        if (Table.isTag(name)) {
            Table table = new Table(attributes);
            float[] widths = table.getProportionalWidths();
            int i = 0;
            while (i < widths.length) {
                if (widths[i] == 0.0f) {
                    widths[i] = 100.0f / (float)widths.length;
                }
                ++i;
            }
            try {
                table.setWidths(widths);
            }
            catch (BadElementException bee) {
                throw new ExceptionConverter(bee);
            }
            this.stack.push(table);
            return;
        }
        if (Section.isTag(name)) {
            Section section;
            Element previous = (Element)this.stack.pop();
            try {
                section = ((Section)previous).addSection(attributes);
            }
            catch (ClassCastException cce) {
                throw new ExceptionConverter(cce);
            }
            this.stack.push(previous);
            this.stack.push(section);
            return;
        }
        if (Chapter.isTag(name)) {
            String value = (String)attributes.remove("number");
            this.chapters = value != null ? Integer.parseInt(value) : ++this.chapters;
            Chapter chapter = new Chapter(attributes, this.chapters);
            this.stack.push(chapter);
            return;
        }
        if (Image.isTag(name)) {
            try {
                Image img = Image.getInstance(attributes);
                try {
                    Object current2 = this.stack.pop();
                    if (current2 instanceof Chapter || current2 instanceof Section || current2 instanceof Cell) {
                        ((TextElementArray)current2).add(img);
                        this.stack.push(current2);
                        return;
                    }
                    Stack newStack = new Stack();
                    try {
                        while (!(current2 instanceof Chapter || current2 instanceof Section || current2 instanceof Cell)) {
                            newStack.push(current2);
                            if (current2 instanceof Anchor) {
                                img.setAnnotation(new Annotation(0.0f, 0.0f, 0.0f, 0.0f, ((Anchor)current2).reference()));
                            }
                            current2 = this.stack.pop();
                        }
                        ((TextElementArray)current2).add(img);
                        this.stack.push(current2);
                    }
                    catch (EmptyStackException ese) {
                        this.document.add(img);
                    }
                    while (!newStack.empty()) {
                        this.stack.push(newStack.pop());
                    }
                    return;
                }
                catch (EmptyStackException ese) {
                    try {
                        this.document.add(img);
                    }
                    catch (DocumentException de) {
                        throw new ExceptionConverter(de);
                    }
                    return;
                }
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        }
        if (Annotation.isTag(name)) {
            Annotation annotation = new Annotation(attributes);
            try {
                try {
                    TextElementArray current3 = (TextElementArray)this.stack.pop();
                    try {
                        current3.add(annotation);
                    }
                    catch (Exception e) {
                        this.document.add(annotation);
                    }
                    this.stack.push(current3);
                }
                catch (EmptyStackException ese) {
                    this.document.add(annotation);
                }
                return;
            }
            catch (DocumentException de) {
                throw new ExceptionConverter(de);
            }
        }
        if (this.isNewline(name)) {
            try {
                current = (TextElementArray)this.stack.pop();
                current.add(Chunk.NEWLINE);
                this.stack.push(current);
            }
            catch (EmptyStackException ese) {
                if (this.currentChunk == null) {
                    try {
                        this.document.add(Chunk.NEWLINE);
                    }
                    catch (DocumentException de) {
                        throw new ExceptionConverter(de);
                    }
                }
                this.currentChunk.append("\n");
            }
            return;
        }
        if (this.isNewpage(name)) {
            try {
                current = (TextElementArray)this.stack.pop();
                Chunk newPage = new Chunk("");
                newPage.setNewPage();
                if (this.bf != null) {
                    newPage.setFont(new Font(this.bf));
                }
                current.add(newPage);
                this.stack.push(current);
            }
            catch (EmptyStackException ese) {
                try {
                    this.document.newPage();
                }
                catch (DocumentException de) {
                    throw new ExceptionConverter(de);
                }
            }
            return;
        }
        if ("horizontalrule".equals(name)) {
            Graphic hr = new Graphic();
            hr.setHorizontalLine(1.0f, 100.0f);
            try {
                current = (TextElementArray)this.stack.pop();
                current.add(hr);
                this.stack.push(current);
            }
            catch (EmptyStackException ese) {
                try {
                    this.document.add(hr);
                }
                catch (DocumentException de) {
                    throw new ExceptionConverter(de);
                }
            }
            return;
        }
        if (this.isDocumentRoot(name)) {
            Rectangle pageSize = null;
            String orientation = null;
            Iterator<Object> i = attributes.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = attributes.getProperty(key);
                try {
                    if ("left".equalsIgnoreCase(key)) {
                        this.leftMargin = Float.parseFloat(String.valueOf(value) + "f");
                    }
                    if ("right".equalsIgnoreCase(key)) {
                        this.rightMargin = Float.parseFloat(String.valueOf(value) + "f");
                    }
                    if ("top".equalsIgnoreCase(key)) {
                        this.topMargin = Float.parseFloat(String.valueOf(value) + "f");
                    }
                    if ("bottom".equalsIgnoreCase(key)) {
                        this.bottomMargin = Float.parseFloat(String.valueOf(value) + "f");
                    }
                }
                catch (Exception ex) {
                    throw new ExceptionConverter(ex);
                }
                if ("pagesize".equals(key)) {
                    try {
                        String pageSizeName = value;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("com.lowagie.text.PageSize");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Field pageSizeField = clazz.getField(pageSizeName);
                        pageSize = (Rectangle)pageSizeField.get(null);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new ExceptionConverter(ex);
                    }
                }
                if ("orientation".equals(key)) {
                    try {
                        if (!"landscape".equals(value)) continue;
                        orientation = "landscape";
                        continue;
                    }
                    catch (Exception ex) {
                        throw new ExceptionConverter(ex);
                    }
                }
                try {
                    this.document.add(new Meta(key, value));
                }
                catch (DocumentException de) {
                    throw new ExceptionConverter(de);
                }
            }
            if (pageSize != null) {
                if ("landscape".equals(orientation)) {
                    pageSize = pageSize.rotate();
                }
                this.document.setPageSize(pageSize);
            }
            this.document.setMargins(this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
            if (this.controlOpenClose) {
                this.document.open();
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void characters(char[] ch, int start, int length) {
        if (this.ignore) {
            return;
        }
        String content = new String(ch, start, length);
        if (content.trim().length() == 0) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        int len = content.length();
        boolean newline = false;
        int i = 0;
        while (i < len) {
            char character = content.charAt(i);
            switch (character) {
                case ' ': {
                    if (newline) break;
                    buf.append(character);
                    break;
                }
                case '\n': {
                    if (i <= 0) break;
                    newline = true;
                    buf.append(' ');
                    break;
                }
                case '\r': {
                    break;
                }
                case '\t': {
                    break;
                }
                default: {
                    newline = false;
                    buf.append(character);
                }
            }
            ++i;
        }
        if (this.currentChunk == null) {
            this.currentChunk = this.bf == null ? new Chunk(buf.toString()) : new Chunk(buf.toString(), new Font(this.bf));
        } else {
            this.currentChunk.append(buf.toString());
        }
    }

    public void setBaseFont(BaseFont bf) {
        this.bf = bf;
    }

    public void endElement(String uri, String lname, String name) {
        this.handleEndingTags(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleEndingTags(String name) {
        if ("ignore".equals(name)) {
            this.ignore = false;
            return;
        }
        if (this.ignore) {
            return;
        }
        if (this.isNewpage(name)) return;
        if (Annotation.isTag(name)) return;
        if (Image.isTag(name)) return;
        if (this.isNewline(name)) {
            return;
        }
        try {
            block44: {
                Cell cell;
                Element element;
                Element current;
                if (Section.isTitle(name)) {
                    Paragraph current2 = (Paragraph)this.stack.pop();
                    if (this.currentChunk != null) {
                        current2.add(this.currentChunk);
                        this.currentChunk = null;
                    }
                    Section previous = (Section)this.stack.pop();
                    previous.setTitle(current2);
                    this.stack.push(previous);
                    return;
                }
                if (this.currentChunk != null) {
                    try {
                        current = (TextElementArray)this.stack.pop();
                    }
                    catch (EmptyStackException ese) {
                        current = new Paragraph();
                    }
                    current.add(this.currentChunk);
                    this.stack.push(current);
                    this.currentChunk = null;
                }
                if (Chunk.isTag(name)) {
                    return;
                }
                if (Phrase.isTag(name) || Anchor.isTag(name) || List.isTag(name) || Paragraph.isTag(name)) {
                    current = (Element)this.stack.pop();
                    try {
                        TextElementArray previous = (TextElementArray)this.stack.pop();
                        previous.add(current);
                        this.stack.push(previous);
                        return;
                    }
                    catch (EmptyStackException ese) {
                        this.document.add(current);
                    }
                    return;
                }
                if (ListItem.isTag(name)) {
                    ListItem listItem = (ListItem)this.stack.pop();
                    List list = (List)this.stack.pop();
                    list.add(listItem);
                    this.stack.push(list);
                }
                if (Table.isTag(name)) {
                    Table table = (Table)this.stack.pop();
                    try {
                        TextElementArray previous = (TextElementArray)this.stack.pop();
                        previous.add(table);
                        this.stack.push(previous);
                        return;
                    }
                    catch (EmptyStackException ese) {
                        this.document.add(table);
                    }
                    return;
                }
                if (!Row.isTag(name)) break block44;
                ArrayList<Cell> cells = new ArrayList<Cell>();
                int columns = 0;
                while ((element = (Element)this.stack.pop()).type() == 20) {
                    cell = (Cell)element;
                    columns += cell.colspan();
                    cells.add(cell);
                }
                Table table = (Table)element;
                if (table.columns() < columns) {
                    table.addColumns(columns - table.columns());
                }
                Collections.reverse(cells);
                float[] cellWidths = new float[columns];
                boolean[] cellNulls = new boolean[columns];
                int i = 0;
                while (i < columns) {
                    cellWidths[i] = 0.0f;
                    cellNulls[i] = true;
                    ++i;
                }
                float total = 0.0f;
                int j = 0;
                Iterator i2 = cells.iterator();
                while (i2.hasNext()) {
                    block46: {
                        String width;
                        block45: {
                            cell = (Cell)i2.next();
                            width = cell.cellWidth();
                            if (width != null) break block45;
                            if (cell.colspan() == 1 && cellWidths[j] == 0.0f) {
                                try {
                                    cellWidths[j] = 100.0f / (float)columns;
                                    total += cellWidths[j];
                                }
                                catch (Exception exception) {}
                                break block46;
                            } else if (cell.colspan() == 1) {
                                cellNulls[j] = false;
                            }
                            break block46;
                        }
                        if (cell.colspan() == 1 && width.endsWith("%")) {
                            try {
                                cellWidths[j] = Float.parseFloat(String.valueOf(width.substring(0, width.length() - 1)) + "f");
                                total += cellWidths[j];
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    j += cell.colspan();
                    table.addCell(cell);
                }
                float[] widths = table.getProportionalWidths();
                if (widths.length == columns) {
                    float left = 0.0f;
                    int i3 = 0;
                    while (i3 < columns) {
                        if (cellNulls[i3] && widths[i3] != 0.0f) {
                            left += widths[i3];
                            cellWidths[i3] = widths[i3];
                        }
                        ++i3;
                    }
                    if (100.0 >= (double)total) {
                        int i4 = 0;
                        while (i4 < widths.length) {
                            if (cellWidths[i4] == 0.0f && widths[i4] != 0.0f) {
                                cellWidths[i4] = widths[i4] / left * (100.0f - total);
                            }
                            ++i4;
                        }
                    }
                    table.setWidths(cellWidths);
                }
                this.stack.push(table);
            }
            if (Cell.isTag(name)) {
                return;
            }
            if (Section.isTag(name)) {
                this.stack.pop();
                return;
            }
            if (Chapter.isTag(name)) {
                this.document.add((Element)this.stack.pop());
                return;
            }
            if (!this.isDocumentRoot(name)) return;
            try {
                while (true) {
                    Element element = (Element)this.stack.pop();
                    try {
                        TextElementArray previous = (TextElementArray)this.stack.pop();
                        previous.add(element);
                        this.stack.push(previous);
                    }
                    catch (EmptyStackException es) {
                        this.document.add(element);
                    }
                }
            }
            catch (EmptyStackException element) {
                if (!this.controlOpenClose) return;
                this.document.close();
                return;
            }
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    private boolean isNewpage(String tag) {
        return "newpage".equals(tag);
    }

    private boolean isNewline(String tag) {
        return "newline".equals(tag);
    }

    protected boolean isDocumentRoot(String tag) {
        return "itext".equals(tag);
    }
}

