/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.backup.MailArchiveEntry;
import org.apache.james.mailbox.backup.MailArchiveIterator;
import org.apache.james.mailbox.backup.MailArchiveRestorer;
import org.apache.james.mailbox.backup.MailArchivesLoader;
import org.apache.james.mailbox.backup.MailboxWithAnnotationsArchiveEntry;
import org.apache.james.mailbox.backup.SerializedMailboxId;
import org.apache.james.mailbox.backup.UnknownArchiveEntry;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipMailArchiveRestorer
implements MailArchiveRestorer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipMailArchiveRestorer.class);
    private final MailboxManager mailboxManager;
    private final MailArchivesLoader archiveLoader;

    @Inject
    public ZipMailArchiveRestorer(MailboxManager mailboxManager, MailArchivesLoader archiveLoader) {
        this.mailboxManager = mailboxManager;
        this.archiveLoader = archiveLoader;
    }

    @Override
    public void restore(Username username, InputStream source) throws MailboxException, IOException {
        MailboxSession session = this.mailboxManager.createSystemSession(username);
        this.restoreEntries(source, session);
        this.mailboxManager.endProcessingRequest(session);
    }

    private void restoreEntries(InputStream source, MailboxSession session) throws IOException {
        try (MailArchiveIterator archiveIterator = this.archiveLoader.load(source);){
            List<MailboxWithAnnotationsArchiveEntry> mailboxes = this.readMailboxes(archiveIterator);
            this.restoreMailboxes(session, mailboxes);
        }
    }

    private Map<SerializedMailboxId, MessageManager> restoreMailboxes(MailboxSession session, List<MailboxWithAnnotationsArchiveEntry> mailboxes) {
        return (Map)mailboxes.stream().flatMap(Throwing.function(mailboxEntry -> this.restoreMailboxEntry(session, (MailboxWithAnnotationsArchiveEntry)mailboxEntry).stream()).sneakyThrow()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private List<MailboxWithAnnotationsArchiveEntry> readMailboxes(MailArchiveIterator iterator) {
        ImmutableList.Builder mailboxes = ImmutableList.builder();
        while (iterator.hasNext()) {
            MailArchiveEntry entry = (MailArchiveEntry)iterator.next();
            switch (entry.getType()) {
                case MAILBOX: {
                    mailboxes.add((Object)((MailboxWithAnnotationsArchiveEntry)entry));
                    break;
                }
                case MESSAGE: {
                    break;
                }
                case UNKNOWN: {
                    String entryName = ((UnknownArchiveEntry)entry).getEntryName();
                    LOGGER.warn("unknown entry found in zip :" + entryName);
                }
            }
        }
        return mailboxes.build();
    }

    private Optional<ImmutablePair<SerializedMailboxId, MessageManager>> restoreMailboxEntry(MailboxSession session, MailboxWithAnnotationsArchiveEntry mailboxWithAnnotationsArchiveEntry) throws MailboxException {
        MailboxPath mailboxPath = MailboxPath.forUser((Username)session.getUser(), (String)mailboxWithAnnotationsArchiveEntry.getMailboxName());
        Optional newMailboxId = this.mailboxManager.createMailbox(mailboxPath, session);
        this.mailboxManager.updateAnnotations(mailboxPath, session, mailboxWithAnnotationsArchiveEntry.getAnnotations());
        return newMailboxId.map(Throwing.function(newId -> ImmutablePair.of((Object)mailboxWithAnnotationsArchiveEntry.getMailboxId(), (Object)this.mailboxManager.getMailbox(newId, session))).sneakyThrow());
    }
}

