/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.time.Instant;
import java.util.function.Supplier;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.RegistrationKey;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaChangeNotifier;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.mailbox.store.event.EventFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultQuotaChangeNotifier
implements QuotaChangeNotifier {
    private static final ImmutableSet<RegistrationKey> NO_REGISTRATION_KEYS = ImmutableSet.of();
    private final UsernameSupplier usernameSupplier;
    private final UserQuotaRootResolver quotaRootResolver;
    private final EventBus eventBus;
    private final QuotaManager quotaManager;

    @Inject
    public DefaultQuotaChangeNotifier(UsernameSupplier usernameSupplier, UserQuotaRootResolver quotaRootResolver, EventBus eventBus, QuotaManager quotaManager) {
        this.usernameSupplier = usernameSupplier;
        this.quotaRootResolver = quotaRootResolver;
        this.eventBus = eventBus;
        this.quotaManager = quotaManager;
    }

    public Publisher<Void> notifyUpdate(QuotaRoot quotaRoot) {
        Username username = this.quotaRootResolver.associatedUsername(quotaRoot);
        return Mono.from((Publisher)this.quotaManager.getQuotasReactive(quotaRoot)).flatMap(quotas -> this.eventBus.dispatch((Event)EventFactory.quotaUpdated().randomEventId().user(username).quotaRoot(quotaRoot).quotaCount((Quota<QuotaCountLimit, QuotaCountUsage>)quotas.getMessageQuota()).quotaSize((Quota<QuotaSizeLimit, QuotaSizeUsage>)quotas.getStorageQuota()).instant(Instant.now()).build(), NO_REGISTRATION_KEYS));
    }

    public Publisher<Void> notifyUpdate(Domain domain) {
        return ((Flux)this.usernameSupplier.get()).map(arg_0 -> ((UserQuotaRootResolver)this.quotaRootResolver).forUser(arg_0)).filter(user -> user.getDomain().map(arg_0 -> ((Domain)domain).equals(arg_0)).orElse(false)).concatMap(this::notifyUpdate).then();
    }

    public Publisher<Void> notifyGlobalUpdate() {
        return ((Flux)this.usernameSupplier.get()).map(arg_0 -> ((UserQuotaRootResolver)this.quotaRootResolver).forUser(arg_0)).concatMap(this::notifyUpdate).then();
    }

    @FunctionalInterface
    public static interface UsernameSupplier
    extends Supplier<Flux<Username>> {
    }
}

