/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.filtering;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.Username;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.api.filtering.RuleDTO;
import org.apache.james.jmap.api.filtering.Rules;
import org.apache.james.jmap.api.filtering.Version;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregateId;
import org.apache.james.jmap.postgres.filtering.PostgresFilteringProjectionDataDefinition;
import org.jooq.Field;
import org.jooq.JSON;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class PostgresFilteringProjectionDAO {
    private final PostgresExecutor postgresExecutor;
    private final ObjectMapper objectMapper;

    @Inject
    public PostgresFilteringProjectionDAO(PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
        this.objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module());
    }

    public Publisher<Rules> listRulesForUser(Username username) {
        return this.postgresExecutor.executeRow(dslContext -> dslContext.selectFrom(PostgresFilteringProjectionDataDefinition.PostgresFilteringProjectionTable.TABLE_NAME).where(PostgresFilteringProjectionDataDefinition.PostgresFilteringProjectionTable.AGGREGATE_ID.eq((Object)new FilteringAggregateId(username).asAggregateKey()))).handle((row, sink) -> {
            try {
                Rules rules = this.parseRules((Record)row);
                sink.next((Object)rules);
            }
            catch (JsonProcessingException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Void> upsert(AggregateId aggregateId, EventId eventId, ImmutableList<Rule> rules) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresFilteringProjectionDataDefinition.PostgresFilteringProjectionTable.TABLE_NAME).set(PostgresFilteringProjectionDataDefinition.PostgresFilteringProjectionTable.AGGREGATE_ID, (Object)aggregateId.asAggregateKey()).set(PostgresFilteringProjectionDataDefinition.PostgresFilteringProjectionTable.EVENT_ID, (Object)eventId.value()).set(PostgresFilteringProjectionDataDefinition.PostgresFilteringProjectionTable.RULES, (Object)this.convertToJooqJson((List<Rule>)rules)).onConflict(new Field[]{PostgresFilteringProjectionDataDefinition.PostgresFilteringProjectionTable.AGGREGATE_ID}).doUpdate().set(PostgresFilteringProjectionDataDefinition.PostgresFilteringProjectionTable.EVENT_ID, (Object)eventId.value()).set(PostgresFilteringProjectionDataDefinition.PostgresFilteringProjectionTable.RULES, (Object)this.convertToJooqJson((List<Rule>)rules))));
    }

    public Publisher<Version> getVersion(Username username) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(PostgresFilteringProjectionDataDefinition.PostgresFilteringProjectionTable.EVENT_ID).from(PostgresFilteringProjectionDataDefinition.PostgresFilteringProjectionTable.TABLE_NAME).where(PostgresFilteringProjectionDataDefinition.PostgresFilteringProjectionTable.AGGREGATE_ID.eq((Object)new FilteringAggregateId(username).asAggregateKey())))).map(this::parseVersion);
    }

    private Rules parseRules(Record record) throws JsonProcessingException {
        List ruleDTOS = (List)this.objectMapper.readValue(((JSON)record.get(PostgresFilteringProjectionDataDefinition.PostgresFilteringProjectionTable.RULES)).data(), (TypeReference)new TypeReference<List<RuleDTO>>(this){});
        return new Rules((List)RuleDTO.toRules((List)ruleDTOS), this.parseVersion(record));
    }

    private Version parseVersion(Record record) {
        return new Version(((Integer)record.get(PostgresFilteringProjectionDataDefinition.PostgresFilteringProjectionTable.EVENT_ID)).intValue());
    }

    private JSON convertToJooqJson(List<Rule> rules) {
        try {
            return JSON.json((String)this.objectMapper.writeValueAsString((Object)RuleDTO.from(rules)));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

