/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class IdsQuery
extends QueryBase
implements QueryVariant {
    private final List<String> values;
    public static final JsonpDeserializer<IdsQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IdsQuery::setupIdsQueryDeserializer);

    private IdsQuery(Builder builder) {
        super(builder);
        this.values = ApiTypeHelper.unmodifiable(builder.values);
    }

    public static IdsQuery of(Function<Builder, ObjectBuilder<IdsQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Ids;
    }

    public final List<String> values() {
        return this.values;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.values)) {
            generator.writeKey("values");
            generator.writeStartArray();
            for (String item0 : this.values) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public Builder toBuilder() {
        return this.toBuilder(new Builder()).values(this.values);
    }

    protected static void setupIdsQueryDeserializer(ObjectDeserializer<Builder> op) {
        IdsQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::values, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "values");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IdsQuery> {
        @Nullable
        private List<String> values;

        public final Builder values(List<String> list) {
            this.values = Builder._listAddAll(this.values, list);
            return this;
        }

        public final Builder values(String value, String ... values) {
            this.values = Builder._listAdd(this.values, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IdsQuery build() {
            this._checkSingleUse();
            return new IdsQuery(this);
        }
    }
}

