/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.request;

import com.google.common.base.MoreObjects;
import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.message.Literal;
import org.apache.james.imap.message.request.AbstractImapRequest;

public class ReplaceRequest
extends AbstractImapRequest
implements Closeable {
    private final long id;
    private final String mailboxName;
    private final Flags flags;
    private final Date datetime;
    private final Literal message;
    private final boolean useUid;

    public ReplaceRequest(long id, String mailboxName, Flags flags, Date datetime, Literal message, Tag tag, boolean useUid) {
        super(tag, ImapConstants.REPLACE_COMMAND);
        this.mailboxName = mailboxName;
        this.flags = flags;
        this.datetime = datetime;
        this.message = message;
        this.id = id;
        this.useUid = useUid;
    }

    public long getId() {
        return this.id;
    }

    public Date getDatetime() {
        return this.datetime;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public String getMailboxName() {
        return this.mailboxName;
    }

    public boolean isUseUid() {
        return this.useUid;
    }

    public Literal getMessage() {
        return this.message;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("mailboxName", (Object)this.mailboxName).add("flags", (Object)this.flags).add("datetime", (Object)this.datetime).add("message", (Object)this.message).add("useUid", this.useUid).toString();
    }

    @Override
    public void close() throws IOException {
        if (this.message instanceof Closeable) {
            ((Closeable)((Object)this.message)).close();
        }
    }
}

