/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

public enum QuicPacketType {
    INITIAL(1),
    RETRY(2),
    HANDSHAKE(3),
    ZERO_RTT(4),
    SHORT(5),
    VERSION_NEGOTIATION(6);

    final byte type;

    private QuicPacketType(byte type) {
        this.type = type;
    }

    static QuicPacketType of(byte type) {
        switch (type) {
            case 1: {
                return INITIAL;
            }
            case 2: {
                return RETRY;
            }
            case 3: {
                return HANDSHAKE;
            }
            case 4: {
                return ZERO_RTT;
            }
            case 5: {
                return SHORT;
            }
            case 6: {
                return VERSION_NEGOTIATION;
            }
        }
        throw new IllegalArgumentException("Unknown QUIC packet type: " + type);
    }
}

