/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.reroute;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.cluster.reroute.RerouteDecision;
import org.opensearch.client.opensearch.cluster.reroute.RerouteParameters;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class RerouteExplanation
implements JsonpSerializable {
    private final String command;
    private final List<RerouteDecision> decisions;
    private final RerouteParameters parameters;
    public static final JsonpDeserializer<RerouteExplanation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerouteExplanation::setupRerouteExplanationDeserializer);

    private RerouteExplanation(Builder builder) {
        this.command = ApiTypeHelper.requireNonNull(builder.command, this, "command");
        this.decisions = ApiTypeHelper.unmodifiableRequired(builder.decisions, (Object)this, "decisions");
        this.parameters = ApiTypeHelper.requireNonNull(builder.parameters, this, "parameters");
    }

    public static RerouteExplanation of(Function<Builder, ObjectBuilder<RerouteExplanation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String command() {
        return this.command;
    }

    public final List<RerouteDecision> decisions() {
        return this.decisions;
    }

    public final RerouteParameters parameters() {
        return this.parameters;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("command");
        generator.write(this.command);
        if (ApiTypeHelper.isDefined(this.decisions)) {
            generator.writeKey("decisions");
            generator.writeStartArray();
            for (RerouteDecision item0 : this.decisions) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("parameters");
        this.parameters.serialize(generator, mapper);
    }

    protected static void setupRerouteExplanationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::command, JsonpDeserializer.stringDeserializer(), "command");
        op.add(Builder::decisions, JsonpDeserializer.arrayDeserializer(RerouteDecision._DESERIALIZER), "decisions");
        op.add(Builder::parameters, RerouteParameters._DESERIALIZER, "parameters");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RerouteExplanation> {
        private String command;
        private List<RerouteDecision> decisions;
        private RerouteParameters parameters;

        public final Builder command(String value) {
            this.command = value;
            return this;
        }

        public final Builder decisions(List<RerouteDecision> list) {
            this.decisions = Builder._listAddAll(this.decisions, list);
            return this;
        }

        public final Builder decisions(RerouteDecision value, RerouteDecision ... values) {
            this.decisions = Builder._listAdd(this.decisions, value, values);
            return this;
        }

        public final Builder decisions(Function<RerouteDecision.Builder, ObjectBuilder<RerouteDecision>> fn) {
            return this.decisions(fn.apply(new RerouteDecision.Builder()).build(), new RerouteDecision[0]);
        }

        public final Builder parameters(RerouteParameters value) {
            this.parameters = value;
            return this;
        }

        public final Builder parameters(Function<RerouteParameters.Builder, ObjectBuilder<RerouteParameters>> fn) {
            return this.parameters(fn.apply(new RerouteParameters.Builder()).build());
        }

        @Override
        public RerouteExplanation build() {
            this._checkSingleUse();
            return new RerouteExplanation(this);
        }
    }
}

