/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.type;

import java.util.Arrays;

public enum CmdType {
    ADDUSER("AddUser", "username", "password"),
    REMOVEUSER("RemoveUser", "username"),
    LISTUSERS("ListUsers", new String[0]),
    ADDDOMAIN("AddDomain", "domainName"),
    REMOVEDOMAIN("RemoveDomain", "domainName"),
    CONTAINSDOMAIN("ContainsDomain", "domainName"),
    LISTDOMAINS("ListDomains", new String[0]),
    LISTMAPPINGS("ListMappings", new String[0]),
    LISTUSERDOMAINMAPPINGS("ListUserDomainMappings", "user", "domain"),
    ADDADDRESSMAPPING("AddAddressMapping", "fromUser", "fromDomain", "toAddress"),
    REMOVEADDRESSMAPPING("RemoveAddressMapping", "fromUser", "fromDomain", "toAddress"),
    ADDREGEXMAPPING("AddRegexMapping", "user", "domain", "regex"),
    REMOVEREGEXMAPPING("RemoveRegexMapping", "user", "domain", "regex"),
    SETPASSWORD("SetPassword", "username", "password"),
    COPYMAILBOX("CopyMailbox", "srcBean", "dstBean"),
    DELETEUSERMAILBOXES("DeleteUserMailboxes", "user"),
    CREATEMAILBOX("CreateMailbox", "namespace", "user", "name"),
    LISTUSERMAILBOXES("ListUserMailboxes", "user"),
    DELETEMAILBOX("DeleteMailbox", "namespace", "user", "name"),
    IMPORTEML("ImportEml", "namespace", "user", "name", "path"),
    GETSTORAGEQUOTA("GetStorageQuota", "quotaroot"),
    GETMESSAGECOUNTQUOTA("GetMessageCountQuota", "quotaroot"),
    GETQUOTAROOT("GetQuotaroot", "namespace", "user", "name"),
    GETMAXSTORAGEQUOTA("GetMaxStorageQuota", "quotaroot"),
    GETMAXMESSAGECOUNTQUOTA("GetMaxMessageCountQuota", "quotaroot"),
    SETMAXSTORAGEQUOTA("SetMaxStorageQuota", "quotaroot", "maxMessageCount"),
    SETMAXMESSAGECOUNTQUOTA("SetMaxMessageCountQuota", "quotaroot", "maxStorage"),
    SETGLOBALMAXSTORAGEQUOTA("SetGlobalMaxStorageQuota", "maxStorage"),
    SETGLOBALMAXMESSAGECOUNTQUOTA("SetGlobalMaxMessageCountQuota", "maxMessageCount"),
    GETGLOBALMAXSTORAGEQUOTA("GetGlobalMaxStorageQuota", new String[0]),
    GETGLOBALMAXMESSAGECOUNTQUOTA("GetGlobalMaxMessageCountQuota", new String[0]),
    REINDEXMAILBOX("ReindexMailbox", "namespace", "user", "name"),
    REINDEXALL("ReindexAll", new String[0]),
    GETSIEVEQUOTA("GetSieveQuota", new String[0]),
    SETSIEVEQUOTA("SetSieveQuota", "quota"),
    REMOVESIEVEQUOTA("RemoveSieveQuota", new String[0]),
    GETSIEVEUSERQUOTA("GetSieveUserQuota", "username"),
    SETSIEVEUSERQUOTA("SetSieveUserQuota", "username", "quota"),
    REMOVESIEVEUSERQUOTA("RemoveSieveUserQuota", "username"),
    ADDACTIVESIEVESCRIPT("AddActiveSieveScript", "username", "scriptname", "path");

    private final String command;
    private final String[] arguments;

    private CmdType(String command, String ... arguments) {
        this.command = command;
        this.arguments = arguments;
    }

    public boolean hasCorrectArguments(int arguments) {
        return this.arguments.length + 1 == arguments;
    }

    public static CmdType lookup(String command) {
        if (command != null) {
            return Arrays.stream(CmdType.values()).filter(cmd -> cmd.getCommand().equalsIgnoreCase(command)).findFirst().orElse(null);
        }
        return null;
    }

    public String getCommand() {
        return this.command;
    }

    public int getArgumentCount() {
        return this.arguments.length + 1;
    }

    public String getUsage() {
        StringBuilder stringBuilder = new StringBuilder(this.command);
        for (String argument : this.arguments) {
            stringBuilder.append(" <" + argument + ">");
        }
        return stringBuilder.toString();
    }
}

