/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.ProtocolSessionImpl;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.LineHandler;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class LineHandlerUpstreamHandler<S extends ProtocolSession>
extends SimpleChannelUpstreamHandler {
    private final LineHandler<S> handler;
    private final S session;

    public LineHandlerUpstreamHandler(S session, LineHandler<S> handler) {
        this.handler = handler;
        this.session = session;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer buf = (ChannelBuffer)e.getMessage();
        Response response = this.handler.onLine(this.session, buf.toByteBuffer());
        if (response != null) {
            ((ProtocolSessionImpl)this.session).getProtocolTransport().writeResponse(response, this.session);
        }
    }
}

