/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.JSONLDAPConnectionLoggerProperties;
import com.unboundid.ldap.sdk.LDAPConnectionInfo;
import com.unboundid.ldap.sdk.LDAPConnectionLogger;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldap.sdk.ReadOnlyCompareRequest;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONLDAPConnectionLogger
extends LDAPConnectionLogger {
    @NotNull
    private static final String REDACTED_VALUE_STRING = "[REDACTED]";
    @NotNull
    private static final byte[] REDACTED_VALUE_BYTES = StaticUtils.getBytes("[REDACTED]");
    private final boolean flushAfterConnectMessages;
    private final boolean flushAfterDisconnectMessages;
    private final boolean flushAfterRequestMessages;
    private final boolean flushAfterFinalResultMessages;
    private final boolean flushAfterNonFinalResultMessages;
    private final boolean includeAddAttributeNames;
    private final boolean includeAddAttributeValues;
    private final boolean includeModifyAttributeNames;
    private final boolean includeModifyAttributeValues;
    private final boolean includeControlOIDs;
    private final boolean includeSearchEntryAttributeNames;
    private final boolean includeSearchEntryAttributeValues;
    private final boolean logConnects;
    private final boolean logDisconnects;
    private final boolean logIntermediateResponses;
    private final boolean logRequests;
    private final boolean logFinalResults;
    private final boolean logSearchEntries;
    private final boolean logSearchReferences;
    @NotNull
    private final Handler logHandler;
    @Nullable
    private final Schema schema;
    @NotNull
    private final Set<OperationType> operationTypes;
    @NotNull
    private final Set<String> attributesToRedact;
    @NotNull
    private final Set<String> fullAttributesToRedact;
    @NotNull
    private final ThreadLocal<JSONBuffer> jsonBuffers;
    @NotNull
    private final ThreadLocal<SimpleDateFormat> timestampFormatters;

    public JSONLDAPConnectionLogger(@NotNull Handler logHandler, @NotNull JSONLDAPConnectionLoggerProperties properties) {
        this.logHandler = logHandler;
        this.flushAfterConnectMessages = properties.flushAfterConnectMessages();
        this.flushAfterDisconnectMessages = properties.flushAfterDisconnectMessages();
        this.flushAfterRequestMessages = properties.flushAfterRequestMessages();
        this.flushAfterFinalResultMessages = properties.flushAfterFinalResultMessages();
        this.flushAfterNonFinalResultMessages = properties.flushAfterNonFinalResultMessages();
        this.includeAddAttributeNames = properties.includeAddAttributeNames();
        this.includeAddAttributeValues = properties.includeAddAttributeValues();
        this.includeModifyAttributeNames = properties.includeModifyAttributeNames();
        this.includeModifyAttributeValues = properties.includeModifyAttributeValues();
        this.includeControlOIDs = properties.includeControlOIDs();
        this.includeSearchEntryAttributeNames = properties.includeSearchEntryAttributeNames();
        this.includeSearchEntryAttributeValues = properties.includeSearchEntryAttributeValues();
        this.logConnects = properties.logConnects();
        this.logDisconnects = properties.logDisconnects();
        this.logIntermediateResponses = properties.logIntermediateResponses();
        this.logRequests = properties.logRequests();
        this.logFinalResults = properties.logFinalResults();
        this.logSearchEntries = properties.logSearchEntries();
        this.logSearchReferences = properties.logSearchReferences();
        this.schema = properties.getSchema();
        this.attributesToRedact = Collections.unmodifiableSet(new LinkedHashSet<String>(properties.getAttributesToRedact()));
        EnumSet<OperationType> opTypes = EnumSet.noneOf(OperationType.class);
        opTypes.addAll(properties.getOperationTypes());
        this.operationTypes = Collections.unmodifiableSet(opTypes);
        this.jsonBuffers = new ThreadLocal();
        this.timestampFormatters = new ThreadLocal();
        HashSet<String> fullAttrsToRedact = new HashSet<String>();
        for (String attr : this.attributesToRedact) {
            AttributeTypeDefinition d;
            fullAttrsToRedact.add(StaticUtils.toLowerCase(attr));
            if (this.schema == null || (d = this.schema.getAttributeType(attr)) == null) continue;
            fullAttrsToRedact.add(StaticUtils.toLowerCase(d.getOID()));
            for (String name : d.getNames()) {
                fullAttrsToRedact.add(StaticUtils.toLowerCase(name));
            }
        }
        this.fullAttributesToRedact = Collections.unmodifiableSet(fullAttrsToRedact);
    }

    public boolean logConnects() {
        return this.logConnects;
    }

    public boolean logDisconnects() {
        return this.logDisconnects;
    }

    public boolean logRequests() {
        return this.logRequests;
    }

    public boolean logFinalResults() {
        return this.logFinalResults;
    }

    public boolean logSearchEntries() {
        return this.logSearchEntries;
    }

    public boolean logSearchReferences() {
        return this.logSearchReferences;
    }

    public boolean logIntermediateResponses() {
        return this.logIntermediateResponses;
    }

    @NotNull
    public Set<OperationType> getOperationTypes() {
        return this.operationTypes;
    }

    public boolean includeAddAttributeNames() {
        return this.includeAddAttributeNames;
    }

    public boolean includeAddAttributeValues() {
        return this.includeAddAttributeValues;
    }

    public boolean includeModifyAttributeNames() {
        return this.includeModifyAttributeNames;
    }

    public boolean includeModifyAttributeValues() {
        return this.includeModifyAttributeValues;
    }

    public boolean includeSearchEntryAttributeNames() {
        return this.includeSearchEntryAttributeNames;
    }

    public boolean includeSearchEntryAttributeValues() {
        return this.includeSearchEntryAttributeValues;
    }

    @NotNull
    public Set<String> getAttributesToRedact() {
        return this.attributesToRedact;
    }

    public boolean includeControlOIDs() {
        return this.includeControlOIDs;
    }

    public boolean flushAfterConnectMessages() {
        return this.flushAfterConnectMessages;
    }

    public boolean flushAfterDisconnectMessages() {
        return this.flushAfterDisconnectMessages;
    }

    public boolean flushAfterRequestMessages() {
        return this.flushAfterRequestMessages;
    }

    public boolean flushAfterNonFinalResultMessages() {
        return this.flushAfterNonFinalResultMessages;
    }

    public boolean flushAfterFinalResultMessages() {
        return this.flushAfterFinalResultMessages;
    }

    @Nullable
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void logConnect(@NotNull LDAPConnectionInfo connectionInfo, @NotNull String host, @NotNull InetAddress inetAddress, int port) {
        if (this.logConnects) {
            JSONBuffer buffer = this.startLogMessage("connect", null, connectionInfo, -1);
            buffer.appendString("hostname", host);
            buffer.appendString("ip-address", inetAddress.getHostAddress());
            buffer.appendNumber("port", port);
            this.logMessage(buffer, this.flushAfterConnectMessages);
        }
    }

    @Override
    public void logConnectFailure(@NotNull LDAPConnectionInfo connectionInfo, @NotNull String host, int port, @NotNull LDAPException connectException) {
        if (this.logConnects) {
            JSONBuffer buffer = this.startLogMessage("connect-failure", null, connectionInfo, -1);
            buffer.appendString("hostname", host);
            buffer.appendNumber("port", port);
            if (connectException != null) {
                this.appendException(buffer, "connect-exception", connectException);
            }
            this.logMessage(buffer, this.flushAfterConnectMessages);
        }
    }

    @Override
    public void logDisconnect(@NotNull LDAPConnectionInfo connectionInfo, @NotNull String host, int port, @NotNull DisconnectType disconnectType, @Nullable String disconnectMessage, @Nullable Throwable disconnectCause) {
        if (this.logDisconnects) {
            JSONBuffer buffer = this.startLogMessage("disconnect", null, connectionInfo, -1);
            buffer.appendString("hostname", host);
            buffer.appendNumber("port", port);
            buffer.appendString("disconnect-type", disconnectType.name());
            if (disconnectMessage != null) {
                buffer.appendString("disconnect-message", disconnectMessage);
            }
            if (disconnectCause != null) {
                this.appendException(buffer, "disconnect-cause", disconnectCause);
            }
            this.logMessage(buffer, this.flushAfterDisconnectMessages);
        }
    }

    @Override
    public void logAbandonRequest(@NotNull LDAPConnectionInfo connectionInfo, int messageID, int messageIDToAbandon, @NotNull List<Control> requestControls) {
        if (this.logRequests && this.operationTypes.contains((Object)OperationType.ABANDON)) {
            JSONBuffer buffer = this.startLogMessage("request", OperationType.ABANDON, connectionInfo, messageID);
            buffer.appendNumber("message-id-to-abandon", messageIDToAbandon);
            this.appendControls(buffer, "control-oids", requestControls);
            this.logMessage(buffer, this.flushAfterRequestMessages);
        }
    }

    @Override
    public void logAddRequest(@NotNull LDAPConnectionInfo connectionInfo, int messageID, @NotNull ReadOnlyAddRequest addRequest) {
        if (this.logRequests && this.operationTypes.contains((Object)OperationType.ADD)) {
            JSONBuffer buffer = this.startLogMessage("request", OperationType.ADD, connectionInfo, messageID);
            this.appendDN(buffer, "dn", addRequest.getDN());
            if (this.includeAddAttributeNames) {
                this.appendAttributes(buffer, "attributes", addRequest.getAttributes(), this.includeAddAttributeValues);
            }
            this.appendControls(buffer, "control-oids", addRequest.getControls());
            this.logMessage(buffer, this.flushAfterRequestMessages);
        }
    }

    @Override
    public void logAddResult(@NotNull LDAPConnectionInfo connectionInfo, int requestMessageID, @NotNull LDAPResult addResult) {
        this.logLDAPResult(connectionInfo, OperationType.ADD, requestMessageID, addResult);
    }

    @Override
    public void logBindRequest(@NotNull LDAPConnectionInfo connectionInfo, int messageID, @NotNull SimpleBindRequest bindRequest) {
        if (this.logRequests && this.operationTypes.contains((Object)OperationType.BIND)) {
            JSONBuffer buffer = this.startLogMessage("request", OperationType.BIND, connectionInfo, messageID);
            buffer.appendString("authentication-type", "simple");
            this.appendDN(buffer, "dn", bindRequest.getBindDN());
            this.appendControls(buffer, "control-oids", bindRequest.getControls());
            this.logMessage(buffer, this.flushAfterRequestMessages);
        }
    }

    @Override
    public void logBindRequest(@NotNull LDAPConnectionInfo connectionInfo, int messageID, @NotNull SASLBindRequest bindRequest) {
        if (this.logRequests && this.operationTypes.contains((Object)OperationType.BIND)) {
            JSONBuffer buffer = this.startLogMessage("request", OperationType.BIND, connectionInfo, messageID);
            buffer.appendString("authentication-type", "SASL");
            buffer.appendString("sasl-mechanism", bindRequest.getSASLMechanismName());
            this.appendControls(buffer, "control-oids", bindRequest.getControls());
            this.logMessage(buffer, this.flushAfterRequestMessages);
        }
    }

    @Override
    public void logBindResult(@NotNull LDAPConnectionInfo connectionInfo, int requestMessageID, @NotNull BindResult bindResult) {
        this.logLDAPResult(connectionInfo, OperationType.BIND, requestMessageID, bindResult);
    }

    @Override
    public void logCompareRequest(@NotNull LDAPConnectionInfo connectionInfo, int messageID, @NotNull ReadOnlyCompareRequest compareRequest) {
        if (this.logRequests && this.operationTypes.contains((Object)OperationType.COMPARE)) {
            JSONBuffer buffer = this.startLogMessage("request", OperationType.COMPARE, connectionInfo, messageID);
            this.appendDN(buffer, "dn", compareRequest.getDN());
            this.appendDN(buffer, "attribute-type", compareRequest.getAttributeName());
            String baseName = StaticUtils.toLowerCase(Attribute.getBaseName(compareRequest.getAttributeName()));
            if (this.fullAttributesToRedact.contains(baseName)) {
                buffer.appendString("assertion-value", REDACTED_VALUE_STRING);
            } else {
                buffer.appendString("assertion-value", compareRequest.getAssertionValue());
            }
            this.appendControls(buffer, "control-oids", compareRequest.getControls());
            this.logMessage(buffer, this.flushAfterRequestMessages);
        }
    }

    @Override
    public void logCompareResult(@NotNull LDAPConnectionInfo connectionInfo, int requestMessageID, @NotNull LDAPResult compareResult) {
        this.logLDAPResult(connectionInfo, OperationType.COMPARE, requestMessageID, compareResult);
    }

    @Override
    public void logDeleteRequest(@NotNull LDAPConnectionInfo connectionInfo, int messageID, @NotNull ReadOnlyDeleteRequest deleteRequest) {
        if (this.logRequests && this.operationTypes.contains((Object)OperationType.DELETE)) {
            JSONBuffer buffer = this.startLogMessage("request", OperationType.DELETE, connectionInfo, messageID);
            this.appendDN(buffer, "dn", deleteRequest.getDN());
            this.appendControls(buffer, "control-oids", deleteRequest.getControls());
            this.logMessage(buffer, this.flushAfterRequestMessages);
        }
    }

    @Override
    public void logDeleteResult(@NotNull LDAPConnectionInfo connectionInfo, int requestMessageID, @NotNull LDAPResult deleteResult) {
        this.logLDAPResult(connectionInfo, OperationType.DELETE, requestMessageID, deleteResult);
    }

    @Override
    public void logExtendedRequest(@NotNull LDAPConnectionInfo connectionInfo, int messageID, @NotNull ExtendedRequest extendedRequest) {
        if (this.logRequests && this.operationTypes.contains((Object)OperationType.EXTENDED)) {
            JSONBuffer buffer = this.startLogMessage("request", OperationType.EXTENDED, connectionInfo, messageID);
            buffer.appendString("oid", extendedRequest.getOID());
            buffer.appendBoolean("has-value", extendedRequest.getValue() != null);
            this.appendControls(buffer, "control-oids", extendedRequest.getControls());
            this.logMessage(buffer, this.flushAfterRequestMessages);
        }
    }

    @Override
    public void logExtendedResult(@NotNull LDAPConnectionInfo connectionInfo, int requestMessageID, @NotNull ExtendedResult extendedResult) {
        this.logLDAPResult(connectionInfo, OperationType.EXTENDED, requestMessageID, extendedResult);
    }

    @Override
    public void logModifyRequest(@NotNull LDAPConnectionInfo connectionInfo, int messageID, @NotNull ReadOnlyModifyRequest modifyRequest) {
        if (this.logRequests && this.operationTypes.contains((Object)OperationType.MODIFY)) {
            JSONBuffer buffer = this.startLogMessage("request", OperationType.MODIFY, connectionInfo, messageID);
            this.appendDN(buffer, "dn", modifyRequest.getDN());
            if (this.includeModifyAttributeNames) {
                List<Modification> mods = modifyRequest.getModifications();
                if (this.includeModifyAttributeValues) {
                    buffer.beginArray("modifications");
                    for (Modification m : mods) {
                        buffer.beginObject();
                        String name = m.getAttributeName();
                        buffer.appendString("attribute-name", name);
                        buffer.appendString("modification-type", m.getModificationType().getName());
                        buffer.beginArray("attribute-values");
                        String baseName = StaticUtils.toLowerCase(Attribute.getBaseName(name));
                        if (this.fullAttributesToRedact.contains(baseName)) {
                            for (String value : m.getValues()) {
                                buffer.appendString(REDACTED_VALUE_STRING);
                            }
                        } else {
                            for (String value : m.getValues()) {
                                buffer.appendString(value);
                            }
                        }
                        buffer.endArray();
                        buffer.endObject();
                    }
                    buffer.endArray();
                } else {
                    LinkedHashMap<String, String> modifiedAttributes = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(mods.size()));
                    for (Modification m : modifyRequest.getModifications()) {
                        String name = m.getAttributeName();
                        String lowerName = StaticUtils.toLowerCase(name);
                        if (modifiedAttributes.containsKey(lowerName)) continue;
                        modifiedAttributes.put(lowerName, name);
                    }
                    buffer.beginArray("modified-attributes");
                    for (String attributeName : modifiedAttributes.values()) {
                        buffer.appendString(attributeName);
                    }
                    buffer.endArray();
                }
            }
            this.appendControls(buffer, "control-oids", modifyRequest.getControls());
            this.logMessage(buffer, this.flushAfterRequestMessages);
        }
    }

    @Override
    public void logModifyResult(@NotNull LDAPConnectionInfo connectionInfo, int requestMessageID, @NotNull LDAPResult modifyResult) {
        this.logLDAPResult(connectionInfo, OperationType.MODIFY, requestMessageID, modifyResult);
    }

    @Override
    public void logModifyDNRequest(@NotNull LDAPConnectionInfo connectionInfo, int messageID, @NotNull ReadOnlyModifyDNRequest modifyDNRequest) {
        if (this.logRequests && this.operationTypes.contains((Object)OperationType.MODIFY_DN)) {
            JSONBuffer buffer = this.startLogMessage("request", OperationType.MODIFY_DN, connectionInfo, messageID);
            this.appendDN(buffer, "dn", modifyDNRequest.getDN());
            this.appendDN(buffer, "new-rdn", modifyDNRequest.getNewRDN());
            buffer.appendBoolean("delete-old-rdn", modifyDNRequest.deleteOldRDN());
            String newSuperiorDN = modifyDNRequest.getNewSuperiorDN();
            if (newSuperiorDN != null) {
                this.appendDN(buffer, "new-superior-dn", newSuperiorDN);
            }
            this.appendControls(buffer, "control-oids", modifyDNRequest.getControls());
            this.logMessage(buffer, this.flushAfterRequestMessages);
        }
    }

    @Override
    public void logModifyDNResult(@NotNull LDAPConnectionInfo connectionInfo, int requestMessageID, @NotNull LDAPResult modifyDNResult) {
        this.logLDAPResult(connectionInfo, OperationType.MODIFY_DN, requestMessageID, modifyDNResult);
    }

    @Override
    public void logSearchRequest(@NotNull LDAPConnectionInfo connectionInfo, int messageID, @NotNull ReadOnlySearchRequest searchRequest) {
        if (this.logRequests && this.operationTypes.contains((Object)OperationType.SEARCH)) {
            JSONBuffer buffer = this.startLogMessage("request", OperationType.SEARCH, connectionInfo, messageID);
            this.appendDN(buffer, "base-dn", searchRequest.getBaseDN());
            buffer.appendString("scope", searchRequest.getScope().getName());
            buffer.appendString("dereference-policy", searchRequest.getDereferencePolicy().getName());
            buffer.appendNumber("size-limit", searchRequest.getSizeLimit());
            buffer.appendNumber("time-limit-seconds", searchRequest.getTimeLimitSeconds());
            buffer.appendBoolean("types-only", searchRequest.typesOnly());
            buffer.appendString("filter", this.redactFilter(searchRequest.getFilter()).toString());
            buffer.beginArray("requested-attributes");
            for (String attributeName : searchRequest.getAttributeList()) {
                buffer.appendString(attributeName);
            }
            buffer.endArray();
            this.appendControls(buffer, "control-oids", searchRequest.getControls());
            this.logMessage(buffer, this.flushAfterRequestMessages);
        }
    }

    @Override
    public void logSearchEntry(@NotNull LDAPConnectionInfo connectionInfo, int requestMessageID, @NotNull SearchResultEntry searchEntry) {
        if (this.logSearchEntries && this.operationTypes.contains((Object)OperationType.SEARCH)) {
            JSONBuffer buffer = this.startLogMessage("search-entry", OperationType.SEARCH, connectionInfo, requestMessageID);
            this.appendDN(buffer, "dn", searchEntry.getDN());
            if (this.includeSearchEntryAttributeNames) {
                this.appendAttributes(buffer, "attributes", new ArrayList<Attribute>(searchEntry.getAttributes()), this.includeSearchEntryAttributeValues);
            }
            this.appendControls(buffer, "control-oids", searchEntry.getControls());
            this.logMessage(buffer, this.flushAfterRequestMessages);
        }
    }

    @Override
    public void logSearchReference(@NotNull LDAPConnectionInfo connectionInfo, int requestMessageID, @NotNull SearchResultReference searchReference) {
        if (this.logSearchReferences && this.operationTypes.contains((Object)OperationType.SEARCH)) {
            JSONBuffer buffer = this.startLogMessage("search-reference", OperationType.SEARCH, connectionInfo, requestMessageID);
            buffer.beginArray("referral-urls");
            for (String url : searchReference.getReferralURLs()) {
                buffer.appendString(url);
            }
            buffer.endArray();
            this.appendControls(buffer, "control-oids", searchReference.getControls());
            this.logMessage(buffer, this.flushAfterRequestMessages);
        }
    }

    @Override
    public void logSearchResult(@NotNull LDAPConnectionInfo connectionInfo, int requestMessageID, @NotNull SearchResult searchResult) {
        this.logLDAPResult(connectionInfo, OperationType.SEARCH, requestMessageID, searchResult);
    }

    @Override
    public void logUnbindRequest(@NotNull LDAPConnectionInfo connectionInfo, int messageID, @NotNull List<Control> requestControls) {
        if (this.logRequests && this.operationTypes.contains((Object)OperationType.UNBIND)) {
            JSONBuffer buffer = this.startLogMessage("request", OperationType.UNBIND, connectionInfo, messageID);
            this.appendControls(buffer, "control-oids", requestControls);
            this.logMessage(buffer, this.flushAfterRequestMessages);
        }
    }

    @Override
    public void logIntermediateResponse(@NotNull LDAPConnectionInfo connectionInfo, int messageID, @NotNull IntermediateResponse intermediateResponse) {
        if (this.logIntermediateResponses) {
            JSONBuffer buffer = this.startLogMessage("intermediate-response", null, connectionInfo, messageID);
            String oid = intermediateResponse.getOID();
            if (oid != null) {
                buffer.appendString("oid", oid);
            }
            buffer.appendBoolean("has-value", intermediateResponse.getValue() != null);
            this.appendControls(buffer, "control-oids", intermediateResponse.getControls());
            this.logMessage(buffer, this.flushAfterRequestMessages);
        }
    }

    @NotNull
    private JSONBuffer startLogMessage(@NotNull String messageType, @Nullable OperationType operationType, @NotNull LDAPConnectionInfo connectionInfo, int messageID) {
        String connectionPoolName;
        JSONBuffer buffer = this.jsonBuffers.get();
        if (buffer == null) {
            buffer = new JSONBuffer();
            this.jsonBuffers.set(buffer);
        } else {
            buffer.clear();
        }
        buffer.beginObject();
        SimpleDateFormat timestampFormatter = this.timestampFormatters.get();
        if (timestampFormatter == null) {
            timestampFormatter = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss.SSS'Z'");
            timestampFormatter.setTimeZone(StaticUtils.getUTCTimeZone());
            this.timestampFormatters.set(timestampFormatter);
        }
        buffer.appendString("timestamp", timestampFormatter.format(new Date()));
        buffer.appendString("message-type", messageType);
        if (operationType != null) {
            switch (operationType) {
                case ABANDON: {
                    buffer.appendString("operation-type", "abandon");
                    break;
                }
                case ADD: {
                    buffer.appendString("operation-type", "add");
                    break;
                }
                case BIND: {
                    buffer.appendString("operation-type", "bind");
                    break;
                }
                case COMPARE: {
                    buffer.appendString("operation-type", "compare");
                    break;
                }
                case DELETE: {
                    buffer.appendString("operation-type", "delete");
                    break;
                }
                case EXTENDED: {
                    buffer.appendString("operation-type", "extended");
                    break;
                }
                case MODIFY: {
                    buffer.appendString("operation-type", "modify");
                    break;
                }
                case MODIFY_DN: {
                    buffer.appendString("operation-type", "modify-dn");
                    break;
                }
                case SEARCH: {
                    buffer.appendString("operation-type", "search");
                    break;
                }
                case UNBIND: {
                    buffer.appendString("operation-type", "unbind");
                }
            }
        }
        buffer.appendNumber("connection-id", connectionInfo.getConnectionID());
        String connectionName = connectionInfo.getConnectionName();
        if (connectionName != null) {
            buffer.appendString("connection-name", connectionName);
        }
        if ((connectionPoolName = connectionInfo.getConnectionPoolName()) != null) {
            buffer.appendString("connection-pool-name", connectionPoolName);
        }
        if (messageID >= 0) {
            buffer.appendNumber("ldap-message-id", messageID);
        }
        return buffer;
    }

    private void appendException(@NotNull JSONBuffer buffer, @NotNull String fieldName, @NotNull Throwable exception) {
        buffer.beginObject(fieldName);
        buffer.appendString("exception-class", exception.getClass().getName());
        String message = exception.getMessage();
        if (message != null) {
            buffer.appendString("message", message);
        }
        buffer.beginArray("stack-trace-frames");
        for (StackTraceElement frame : exception.getStackTrace()) {
            buffer.beginObject();
            buffer.appendString("class", frame.getClassName());
            buffer.appendString("method", frame.getMethodName());
            String fileName = frame.getFileName();
            if (fileName != null) {
                buffer.appendString("file", fileName);
            }
            if (frame.isNativeMethod()) {
                buffer.appendBoolean("is-native-method", true);
            } else {
                int lineNumber = frame.getLineNumber();
                if (lineNumber > 0) {
                    buffer.appendNumber("line-number", lineNumber);
                }
            }
            buffer.endObject();
        }
        buffer.endArray();
        Throwable cause = exception.getCause();
        if (cause != null) {
            this.appendException(buffer, "caused-by", cause);
        }
        buffer.endObject();
    }

    private void appendControls(@NotNull JSONBuffer buffer, @NotNull String fieldName, Control ... controls) {
        if (this.includeControlOIDs && controls.length > 0) {
            buffer.beginArray(fieldName);
            for (Control c : controls) {
                buffer.appendString(c.getOID());
            }
            buffer.endArray();
        }
    }

    private void appendControls(@NotNull JSONBuffer buffer, @NotNull String fieldName, @NotNull List<Control> controls) {
        if (this.includeControlOIDs && !controls.isEmpty()) {
            buffer.beginArray(fieldName);
            for (Control c : controls) {
                buffer.appendString(c.getOID());
            }
            buffer.endArray();
        }
    }

    private void appendDN(@NotNull JSONBuffer buffer, @NotNull String fieldName, @NotNull String dn) {
        RDN[] originalRDNs;
        DN parsedDN;
        if (this.fullAttributesToRedact.isEmpty()) {
            buffer.appendString(fieldName, dn);
            return;
        }
        try {
            parsedDN = new DN(dn);
        }
        catch (Exception e) {
            Debug.debugException(e);
            buffer.appendString(fieldName, dn);
            return;
        }
        boolean redactionNeeded = false;
        block2: for (RDN rdn : originalRDNs = parsedDN.getRDNs()) {
            for (String attributeName : rdn.getAttributeNames()) {
                if (!this.fullAttributesToRedact.contains(StaticUtils.toLowerCase(attributeName))) continue;
                redactionNeeded = true;
                continue block2;
            }
        }
        if (redactionNeeded) {
            RDN[] newRDNs = new RDN[originalRDNs.length];
            for (int i = 0; i < originalRDNs.length; ++i) {
                RDN rdn = originalRDNs[i];
                String[] names = rdn.getAttributeNames();
                byte[][] values = new byte[names.length][];
                for (int j = 0; j < names.length; ++j) {
                    String lowerName = StaticUtils.toLowerCase(names[j]);
                    values[j] = this.fullAttributesToRedact.contains(lowerName) ? REDACTED_VALUE_BYTES : rdn.getByteArrayAttributeValues()[j];
                }
                newRDNs[i] = new RDN(names, values, rdn.getSchema());
            }
            buffer.appendString(fieldName, new DN(newRDNs).toString());
        } else {
            buffer.appendString(fieldName, dn);
        }
    }

    private void appendAttributes(@NotNull JSONBuffer buffer, @NotNull String fieldName, @NotNull List<Attribute> attributes, boolean includeValues) {
        buffer.beginArray(fieldName);
        for (Attribute attribute : attributes) {
            if (includeValues) {
                buffer.beginObject();
                buffer.appendString("name", attribute.getName());
                buffer.beginArray("values");
                String baseName = StaticUtils.toLowerCase(attribute.getBaseName());
                if (this.fullAttributesToRedact.contains(baseName)) {
                    for (String value : attribute.getValues()) {
                        buffer.appendString(REDACTED_VALUE_STRING);
                    }
                } else {
                    for (String value : attribute.getValues()) {
                        buffer.appendString(value);
                    }
                }
                buffer.endArray();
                buffer.endObject();
                continue;
            }
            buffer.appendString(attribute.getName());
        }
        buffer.endArray();
    }

    @NotNull
    private Filter redactFilter(@NotNull Filter filter) {
        switch (filter.getFilterType()) {
            case -96: {
                Filter[] currentANDComps = filter.getComponents();
                Filter[] newANDComps = new Filter[currentANDComps.length];
                for (int i = 0; i < currentANDComps.length; ++i) {
                    newANDComps[i] = this.redactFilter(currentANDComps[i]);
                }
                return Filter.createANDFilter(newANDComps);
            }
            case -95: {
                Filter[] currentORComps = filter.getComponents();
                Filter[] newORComps = new Filter[currentORComps.length];
                for (int i = 0; i < currentORComps.length; ++i) {
                    newORComps[i] = this.redactFilter(currentORComps[i]);
                }
                return Filter.createORFilter(newORComps);
            }
            case -94: {
                return Filter.createNOTFilter(this.redactFilter(filter.getNOTComponent()));
            }
            case -93: {
                return Filter.createEqualityFilter(filter.getAttributeName(), this.redactAssertionValue(filter));
            }
            case -91: {
                return Filter.createGreaterOrEqualFilter(filter.getAttributeName(), this.redactAssertionValue(filter));
            }
            case -90: {
                return Filter.createLessOrEqualFilter(filter.getAttributeName(), this.redactAssertionValue(filter));
            }
            case -88: {
                return Filter.createApproximateMatchFilter(filter.getAttributeName(), this.redactAssertionValue(filter));
            }
            case -87: {
                return Filter.createExtensibleMatchFilter(filter.getAttributeName(), filter.getMatchingRuleID(), filter.getDNAttributes(), this.redactAssertionValue(filter));
            }
            case -92: {
                String baseName = StaticUtils.toLowerCase(Attribute.getBaseName(filter.getAttributeName()));
                if (this.fullAttributesToRedact.contains(baseName)) {
                    Object[] redactedSubAnyStrings = new String[filter.getSubAnyStrings().length];
                    Arrays.fill(redactedSubAnyStrings, REDACTED_VALUE_STRING);
                    return Filter.createSubstringFilter(filter.getAttributeName(), filter.getSubInitialString() == null ? null : REDACTED_VALUE_STRING, (String[])redactedSubAnyStrings, filter.getSubFinalString() == null ? null : REDACTED_VALUE_STRING);
                }
                return Filter.createSubstringFilter(filter.getAttributeName(), filter.getSubInitialString(), filter.getSubAnyStrings(), filter.getSubFinalString());
            }
        }
        return filter;
    }

    @NotNull
    private String redactAssertionValue(@NotNull Filter filter) {
        String attributeName = filter.getAttributeName();
        if (attributeName == null) {
            return filter.getAssertionValue();
        }
        String baseName = StaticUtils.toLowerCase(Attribute.getBaseName(attributeName));
        if (this.fullAttributesToRedact.contains(baseName)) {
            return REDACTED_VALUE_STRING;
        }
        return filter.getAssertionValue();
    }

    private void logLDAPResult(@NotNull LDAPConnectionInfo connectionInfo, @NotNull OperationType operationType, int messageID, @NotNull LDAPResult result) {
        if (this.logFinalResults && this.operationTypes.contains((Object)operationType)) {
            String[] referralURLs;
            String matchedDN;
            JSONBuffer buffer = this.startLogMessage("result", operationType, connectionInfo, messageID);
            buffer.appendNumber("result-code-value", result.getResultCode().intValue());
            buffer.appendString("result-code-name", result.getResultCode().getName());
            String diagnosticMessage = result.getDiagnosticMessage();
            if (diagnosticMessage != null) {
                buffer.appendString("diagnostic-message", diagnosticMessage);
            }
            if ((matchedDN = result.getMatchedDN()) != null) {
                buffer.appendString("matched-dn", matchedDN);
            }
            if ((referralURLs = result.getReferralURLs()) != null && referralURLs.length > 0) {
                buffer.beginArray("referral-urls");
                for (String url : referralURLs) {
                    buffer.appendString(url);
                }
                buffer.endArray();
            }
            if (result instanceof BindResult) {
                BindResult bindResult = (BindResult)result;
                if (bindResult.getServerSASLCredentials() != null) {
                    buffer.appendBoolean("has-server-sasl-credentials", true);
                }
            } else if (result instanceof ExtendedResult) {
                ExtendedResult extendedResult = (ExtendedResult)result;
                String oid = extendedResult.getOID();
                if (oid != null) {
                    buffer.appendString("oid", oid);
                }
                buffer.appendBoolean("has-value", extendedResult.getValue() != null);
            }
            this.appendControls(buffer, "control-oids", result.getResponseControls());
            this.logMessage(buffer, this.flushAfterFinalResultMessages);
        }
    }

    private void logMessage(@NotNull JSONBuffer buffer, boolean flushHandler) {
        buffer.endObject();
        this.logHandler.publish(new LogRecord(Level.INFO, buffer.toString()));
        if (flushHandler) {
            this.logHandler.flush();
        }
    }
}

