/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.mailet.Mail;

public class MailKey {
    private final String value;

    public static MailKey forMail(Mail mail) {
        return new MailKey(mail.getName());
    }

    public MailKey(String value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    public String asString() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof MailKey) {
            MailKey mailKey = (MailKey)o;
            return Objects.equals(this.value, mailKey.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }
}

