/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.queue.rabbitmq;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.blob.api.BlobReferenceSource;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.cassandra.dto.EventDTO;
import org.apache.james.eventsourcing.eventstore.cassandra.dto.EventDTOModule;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.queue.rabbitmq.view.api.MailQueueView;
import org.apache.james.queue.rabbitmq.view.cassandra.BrowseStartDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueBrowser;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueMailDelete;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueMailStore;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueView;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueViewStartUpCheck;
import org.apache.james.queue.rabbitmq.view.cassandra.ContentStartDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.DeletedMailsDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.EnqueuedMailsDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.MailQueueViewBlobReferenceSource;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfigurationModule;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.EventsourcingConfigurationManagement;

public class CassandraMailQueueViewModule
extends AbstractModule {
    public static final String RABBITMQ_CONFIGURATION_NAME = "rabbitmq";

    protected void configure() {
        this.bind(EnqueuedMailsDAO.class).in(Scopes.SINGLETON);
        this.bind(DeletedMailsDAO.class).in(Scopes.SINGLETON);
        this.bind(BrowseStartDAO.class).in(Scopes.SINGLETON);
        this.bind(CassandraMailQueueBrowser.class).in(Scopes.SINGLETON);
        this.bind(CassandraMailQueueMailDelete.class).in(Scopes.SINGLETON);
        this.bind(CassandraMailQueueMailStore.class).in(Scopes.SINGLETON);
        this.bind(ContentStartDAO.class).in(Scopes.SINGLETON);
        Multibinder cassandraModuleBinder = Multibinder.newSetBinder((Binder)this.binder(), CassandraModule.class);
        cassandraModuleBinder.addBinding().toInstance((Object)org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueViewModule.MODULE);
        this.bind(EventsourcingConfigurationManagement.class).in(Scopes.SINGLETON);
        Multibinder eventDTOModuleBinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<EventDTOModule<? extends Event, ? extends EventDTO>>(){});
        eventDTOModuleBinder.addBinding().toInstance((Object)CassandraMailQueueViewConfigurationModule.MAIL_QUEUE_VIEW_CONFIGURATION);
        Multibinder.newSetBinder((Binder)this.binder(), StartUpCheck.class).addBinding().to(CassandraMailQueueViewStartUpCheck.class);
        Multibinder.newSetBinder((Binder)this.binder(), BlobReferenceSource.class).addBinding().to(MailQueueViewBlobReferenceSource.class);
    }

    @Provides
    @Singleton
    public MailQueueView.Factory provideMailQueueViewFactory(CassandraMailQueueView.Factory cassandraMailQueueViewFactory) {
        return cassandraMailQueueViewFactory;
    }

    @Provides
    @Singleton
    private CassandraMailQueueViewConfiguration getMailQueueViewConfiguration(@Named(value="rabbitmq") Configuration configuration) {
        return CassandraMailQueueViewConfiguration.from((Configuration)configuration);
    }
}

