/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.base.Preconditions;
import org.apache.james.backends.cassandra.init.LogConsistencyAllRetryPolicy;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.init.configuration.ClusterConfiguration;

public class ClusterFactory {
    public static Cluster create(ClusterConfiguration configuration, CassandraConsistenciesConfiguration consistenciesConfiguration) {
        Preconditions.checkState((configuration.getUsername().isPresent() == configuration.getPassword().isPresent() ? 1 : 0) != 0, (Object)"If you specify username, you must specify password");
        Cluster.Builder clusterBuilder = Cluster.builder().withoutJMXReporting();
        configuration.getHosts().forEach(server -> clusterBuilder.addContactPoint(server.getHostName()).withPort(server.getPort()));
        configuration.getLoadBalancingPolicy().ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withLoadBalancingPolicy(arg_0));
        configuration.getUsername().ifPresent(username -> configuration.getPassword().ifPresent(password -> clusterBuilder.withCredentials(username, password)));
        clusterBuilder.withQueryOptions(ClusterFactory.queryOptions(consistenciesConfiguration));
        SocketOptions socketOptions = new SocketOptions();
        socketOptions.setReadTimeoutMillis(configuration.getReadTimeoutMillis());
        socketOptions.setConnectTimeoutMillis(configuration.getConnectTimeoutMillis());
        clusterBuilder.withSocketOptions(socketOptions);
        clusterBuilder.withRetryPolicy((RetryPolicy)new LogConsistencyAllRetryPolicy());
        configuration.getPoolingOptions().ifPresent(arg_0 -> ((Cluster.Builder)clusterBuilder).withPoolingOptions(arg_0));
        if (configuration.useSsl()) {
            clusterBuilder.withSSL();
        }
        Cluster cluster = clusterBuilder.build();
        try {
            configuration.getQueryLoggerConfiguration().ifPresent(queryLoggerConfiguration -> cluster.register((LatencyTracker)queryLoggerConfiguration.getQueryLogger()));
            ClusterFactory.ensureContactable(cluster);
            return cluster;
        }
        catch (Exception e) {
            cluster.close();
            throw e;
        }
    }

    private static QueryOptions queryOptions(CassandraConsistenciesConfiguration consistenciesConfiguration) {
        return new QueryOptions().setConsistencyLevel(consistenciesConfiguration.getRegular()).setSerialConsistencyLevel(consistenciesConfiguration.getLightweightTransaction());
    }

    private static void ensureContactable(Cluster cluster) {
        try (Session session = cluster.connect("system");){
            session.execute((Statement)ClusterFactory.checkConnectionStatement(session));
        }
    }

    private static BoundStatement checkConnectionStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().fcall("NOW", new Object[0]).from("local")).bind();
    }
}

