/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.compute;

import java.io.Serializable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.PlatformSecurityAwareJob;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.callback.PlatformCallbackGateway;
import org.apache.ignite.internal.processors.platform.memory.PlatformInputStream;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.resources.IgniteInstanceResource;

public abstract class PlatformAbstractFunc
implements PlatformSecurityAwareJob,
Serializable {
    private static final long serialVersionUID = 0L;
    private final Object func;
    private final transient long ptr;
    @IgniteInstanceResource
    protected transient Ignite ignite;
    private final String funcName;

    protected PlatformAbstractFunc(Object func, long ptr, String funcName) {
        this.ptr = ptr;
        assert (func != null);
        this.func = func;
        this.funcName = funcName;
    }

    protected Object invoke() throws IgniteCheckedException {
        assert (this.ignite != null);
        PlatformContext ctx = PlatformUtils.platformContext(this.ignite);
        try (PlatformMemory mem = ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            if (this.ptr != 0L) {
                out.writeBoolean(true);
                out.writeLong(this.ptr);
            } else {
                out.writeBoolean(false);
                ctx.writer(out).writeObject(this.func);
            }
            out.synchronize();
            this.platformCallback(ctx.gateway(), mem.pointer());
            PlatformInputStream in = mem.input();
            in.synchronize();
            Object object = PlatformUtils.readInvocationResult(ctx, ctx.reader(in));
            return object;
        }
    }

    @Override
    public String name() {
        return this.funcName;
    }

    protected abstract void platformCallback(PlatformCallbackGateway var1, long var2);
}

