/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.replication.ScanCloseReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ScanCloseReplicaRequestBuilder;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;

class ScanCloseReplicaRequestDeserializer
implements MessageDeserializer<ScanCloseReplicaRequest> {
    private final ScanCloseReplicaRequestBuilder msg;

    ScanCloseReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.scanCloseReplicaRequest();
    }

    @Override
    public Class<ScanCloseReplicaRequest> klass() {
        return ScanCloseReplicaRequest.class;
    }

    @Override
    public ScanCloseReplicaRequest getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ReplicationGroupIdMessage tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupId(tmp);
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("scanId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.scanId(tmp);
                reader.incrementState();
            }
            case 2: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 3: {
                Comparable<HybridTimestamp> tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 4: {
                Comparable<HybridTimestamp> tmp = reader.readUuid("transactionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.transactionId((UUID)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ScanCloseReplicaRequest.class);
    }
}

