/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.index;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.commands.RemoveIndexCommand;
import org.apache.ignite3.internal.catalog.commands.StartBuildingIndexCommand;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite3.internal.close.ManuallyCloseable;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite3.internal.components.NodeProperties;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.index.ChangeIndexStatusTask;
import org.apache.ignite3.internal.index.ChangeIndexStatusTaskId;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.placementdriver.PlacementDriver;
import org.apache.ignite3.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;

class ChangeIndexStatusTaskScheduler
implements ManuallyCloseable {
    private static final IgniteLogger LOG = Loggers.forClass(ChangeIndexStatusTaskScheduler.class);
    private final CatalogManager catalogManager;
    private final ClusterService clusterService;
    private final LogicalTopologyService logicalTopologyService;
    private final ClockService clockService;
    private final PlacementDriver placementDriver;
    private final IndexMetaStorage indexMetaStorage;
    private final FailureProcessor failureProcessor;
    private final NodeProperties nodeProperties;
    private final Executor executor;
    private final Map<ChangeIndexStatusTaskId, ChangeIndexStatusTask> taskById = new ConcurrentHashMap<ChangeIndexStatusTaskId, ChangeIndexStatusTask>();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean closeGuard = new AtomicBoolean();

    ChangeIndexStatusTaskScheduler(CatalogManager catalogManager, ClusterService clusterService, LogicalTopologyService logicalTopologyService, ClockService clockService, PlacementDriver placementDriver, IndexMetaStorage indexMetaStorage, FailureProcessor failureProcessor, NodeProperties nodeProperties, Executor executor) {
        this.catalogManager = catalogManager;
        this.clusterService = clusterService;
        this.logicalTopologyService = logicalTopologyService;
        this.clockService = clockService;
        this.placementDriver = placementDriver;
        this.indexMetaStorage = indexMetaStorage;
        this.failureProcessor = failureProcessor;
        this.nodeProperties = nodeProperties;
        this.executor = executor;
    }

    @Override
    public void close() throws Exception {
        if (!this.closeGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        this.stopAllTasks();
    }

    void scheduleStartBuildingTask(CatalogIndexDescriptor indexDescriptor) {
        assert (indexDescriptor.status() == CatalogIndexStatus.REGISTERED) : "Index must be REGISTERED " + indexDescriptor;
        LOG.info("Scheduling starting of index building. Index: {}", indexDescriptor);
        IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
            ChangeIndexStatusTaskId taskId = new ChangeIndexStatusTaskId(indexDescriptor);
            this.scheduleTaskBusy(taskId, this.startBuildingIndexTask(indexDescriptor));
        });
    }

    private ChangeIndexStatusTask startBuildingIndexTask(final CatalogIndexDescriptor indexDescriptor) {
        return new ChangeIndexStatusTask(indexDescriptor, this.catalogManager, this.placementDriver, this.clusterService, this.logicalTopologyService, this.clockService, this.indexMetaStorage, this.failureProcessor, this.nodeProperties, this.executor, this.busyLock){

            @Override
            CatalogCommand switchIndexStatusCommand() {
                return StartBuildingIndexCommand.builder().indexId(indexDescriptor.id()).build();
            }
        };
    }

    void scheduleRemoveIndexTask(CatalogIndexDescriptor indexDescriptor) {
        assert (indexDescriptor.status() == CatalogIndexStatus.STOPPING);
        LOG.info("Scheduling index removal. Index: {}", indexDescriptor);
        IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
            ChangeIndexStatusTaskId taskId = new ChangeIndexStatusTaskId(indexDescriptor);
            this.scheduleTaskBusy(taskId, this.removeIndexTask(indexDescriptor));
        });
    }

    private ChangeIndexStatusTask removeIndexTask(final CatalogIndexDescriptor indexDescriptor) {
        return new ChangeIndexStatusTask(indexDescriptor, this.catalogManager, this.placementDriver, this.clusterService, this.logicalTopologyService, this.clockService, this.indexMetaStorage, this.failureProcessor, this.nodeProperties, this.executor, this.busyLock){

            @Override
            CatalogCommand switchIndexStatusCommand() {
                return RemoveIndexCommand.builder().indexId(indexDescriptor.id()).build();
            }
        };
    }

    private void scheduleTaskBusy(ChangeIndexStatusTaskId taskId, ChangeIndexStatusTask task) {
        if (this.taskById.putIfAbsent(taskId, task) == null) {
            task.start().whenComplete((unused, throwable) -> this.taskById.remove(taskId));
        } else {
            LOG.info("Skipping task scheduling, because a task with the same ID is already running.", new Object[0]);
        }
    }

    void stopStartBuildingTask(int indexId) {
        IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
            ChangeIndexStatusTask removed = this.taskById.remove(new ChangeIndexStatusTaskId(indexId, CatalogIndexStatus.REGISTERED));
            if (removed != null) {
                removed.stop();
            }
        });
    }

    void stopTasksForTable(int tableId) {
        IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
            Iterator<ChangeIndexStatusTask> it = this.taskById.values().iterator();
            while (it.hasNext()) {
                ChangeIndexStatusTask task = it.next();
                if (task.targetIndex().tableId() != tableId) continue;
                it.remove();
                task.stop();
            }
        });
    }

    private void stopAllTasks() {
        this.taskById.values().forEach(ChangeIndexStatusTask::stop);
        this.taskById.clear();
    }
}

