/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.util.List;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.utils.AttributedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlCompleter
implements Completer {
    private static final Logger LOG = LoggerFactory.getLogger(SqlCompleter.class);
    private final Executor executor;

    public SqlCompleter(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        String statement = line.line();
        try {
            this.executor.completeStatement(statement, line.cursor()).forEach(hint -> candidates.add(this.createCandidate((String)hint)));
        }
        catch (SqlExecutionException e) {
            LOG.debug("Could not complete statement at " + line.cursor() + ":" + statement, (Throwable)e);
        }
    }

    private Candidate createCandidate(String hint) {
        return new Candidate(AttributedString.stripAnsi(hint), hint, null, null, null, null, true);
    }
}

