/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.service;

import com.twitter.conversions.time$;
import com.twitter.finagle.Address;
import com.twitter.finagle.Address$;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.ServiceFactoryWrapper;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Stackable;
import com.twitter.finagle.client.Transporter$EndpointAddr$;
import com.twitter.finagle.param.Label$;
import com.twitter.finagle.param.Logger$;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.param.Timer$;
import com.twitter.finagle.service.Backoff$;
import com.twitter.finagle.service.FailureAccrualFactory;
import com.twitter.finagle.service.FailureAccrualFactory$Param$;
import com.twitter.finagle.service.FailureAccrualFactory$Param$Disabled$;
import com.twitter.finagle.service.ReqRep;
import com.twitter.finagle.service.ResponseClass;
import com.twitter.finagle.service.ResponseClassifier$;
import com.twitter.finagle.service.exp.FailureAccrualPolicy;
import com.twitter.finagle.service.exp.FailureAccrualPolicy$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.util.package$;
import com.twitter.util.Duration;
import com.twitter.util.Timer;
import java.util.logging.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Stream;
import scala.util.Random;

public final class FailureAccrualFactory$ {
    public static final FailureAccrualFactory$ MODULE$;
    private final Random rng;
    private final int defaultConsecutiveFailures;
    private final Stream<Duration> jitteredBackoff;
    private final Function0<FailureAccrualPolicy> defaultPolicy;
    private final Stack.Role role;
    private final FailureAccrualFactory.Param Disabled;

    static {
        new FailureAccrualFactory$();
    }

    public ServiceFactoryWrapper wrapper(StatsReceiver statsReceiver, FailureAccrualPolicy failureAccrualPolicy, String label, Logger logger, Address endpoint, PartialFunction<ReqRep, ResponseClass> responseClassifier, Timer timer) {
        return new ServiceFactoryWrapper(statsReceiver, failureAccrualPolicy, label, logger, endpoint, responseClassifier, timer){
            private final StatsReceiver statsReceiver$1;
            private final FailureAccrualPolicy failureAccrualPolicy$1;
            private final String label$1;
            private final Logger logger$1;
            private final Address endpoint$1;
            private final PartialFunction responseClassifier$1;
            private final Timer timer$1;

            public <Req, Rep> FailureAccrualFactory<Req, Rep> andThen(ServiceFactory<Req, Rep> factory) {
                return new FailureAccrualFactory<Req, Rep>(factory, this.failureAccrualPolicy$1, this.timer$1, this.statsReceiver$1.scope("failure_accrual"), this.label$1, this.logger$1, this.endpoint$1, (PartialFunction<ReqRep, ResponseClass>)this.responseClassifier$1);
            }
            {
                this.statsReceiver$1 = statsReceiver$1;
                this.failureAccrualPolicy$1 = failureAccrualPolicy$1;
                this.label$1 = label$1;
                this.logger$1 = logger$1;
                this.endpoint$1 = endpoint$1;
                this.responseClassifier$1 = responseClassifier$1;
                this.timer$1 = timer$1;
            }
        };
    }

    public int defaultConsecutiveFailures() {
        return this.defaultConsecutiveFailures;
    }

    public Stream<Duration> jitteredBackoff() {
        return this.jitteredBackoff;
    }

    public Function0<FailureAccrualPolicy> defaultPolicy() {
        return this.defaultPolicy;
    }

    public Function0<Duration> perturb(Duration markDeadFor, float perturbation, Random rand) {
        return new Serializable(markDeadFor, perturbation, rand){
            public static final long serialVersionUID = 0L;
            private final Duration markDeadFor$3;
            private final float perturbation$1;
            private final Random rand$1;

            public final Duration apply() {
                long ms = this.markDeadFor$3.inMilliseconds();
                return time$.MODULE$.intToTimeableNumber((int)((double)ms + (double)((float)((double)ms * (double)this.rand$1.nextFloat()) * this.perturbation$1))).milliseconds();
            }
            {
                this.markDeadFor$3 = markDeadFor$3;
                this.perturbation$1 = perturbation$1;
                this.rand$1 = rand$1;
            }
        };
    }

    public float perturb$default$2() {
        return 0.1f;
    }

    public Random perturb$default$3() {
        return this.rng;
    }

    public Stack.Role role() {
        return this.role;
    }

    public FailureAccrualFactory.Param Param(int numFailures, Function0<Duration> markDeadFor) {
        return new FailureAccrualFactory.Param.Configured((Function0<FailureAccrualPolicy>)new Serializable(numFailures, markDeadFor){
            public static final long serialVersionUID = 0L;
            private final int numFailures$2;
            private final Function0 markDeadFor$2;

            public final FailureAccrualPolicy apply() {
                return FailureAccrualPolicy$.MODULE$.consecutiveFailures(this.numFailures$2, Backoff$.MODULE$.fromFunction((Function0<Duration>)this.markDeadFor$2));
            }
            {
                this.numFailures$2 = numFailures$2;
                this.markDeadFor$2 = markDeadFor$2;
            }
        });
    }

    public FailureAccrualFactory.Param Param(int numFailures, Duration markDeadFor) {
        return new FailureAccrualFactory.Param.Configured((Function0<FailureAccrualPolicy>)new Serializable(numFailures, markDeadFor){
            public static final long serialVersionUID = 0L;
            private final int numFailures$1;
            private final Duration markDeadFor$1;

            public final FailureAccrualPolicy apply() {
                return FailureAccrualPolicy$.MODULE$.consecutiveFailures(this.numFailures$1, Backoff$.MODULE$.const(this.markDeadFor$1));
            }
            {
                this.numFailures$1 = numFailures$1;
                this.markDeadFor$1 = markDeadFor$1;
            }
        });
    }

    public FailureAccrualFactory.Param Param(Function0<FailureAccrualPolicy> failureAccrualPolicy) {
        return new FailureAccrualFactory.Param.Configured(failureAccrualPolicy);
    }

    public FailureAccrualFactory.Param Replaced(Function1<Timer, ServiceFactoryWrapper> factory) {
        return new FailureAccrualFactory.Param.Replaced(factory);
    }

    public FailureAccrualFactory.Param Replaced(ServiceFactoryWrapper factory) {
        return new FailureAccrualFactory.Param.Replaced((Function1<Timer, ServiceFactoryWrapper>)new Serializable(factory){
            public static final long serialVersionUID = 0L;
            private final ServiceFactoryWrapper factory$1;

            public final ServiceFactoryWrapper apply(Timer x$1) {
                return this.factory$1;
            }
            {
                this.factory$1 = factory$1;
            }
        });
    }

    public FailureAccrualFactory.Param Disabled() {
        return this.Disabled;
    }

    public <Req, Rep> Stackable<ServiceFactory<Req, Rep>> module() {
        return new Stack.ModuleParams<ServiceFactory<Req, Rep>>(){
            private final Stack.Role role;
            private final String description;

            public Stack.Role role() {
                return this.role;
            }

            public String description() {
                return this.description;
            }

            public Seq<Stack.Param<?>> parameters() {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Stack.Param[]{(Stack.Param)Predef$.MODULE$.implicitly(Stats$.MODULE$.param()), (Stack.Param)Predef$.MODULE$.implicitly(FailureAccrualFactory$Param$.MODULE$.param()), (Stack.Param)Predef$.MODULE$.implicitly(Timer$.MODULE$.param()), (Stack.Param)Predef$.MODULE$.implicitly(Label$.MODULE$.param()), (Stack.Param)Predef$.MODULE$.implicitly(Logger$.MODULE$.param()), (Stack.Param)Predef$.MODULE$.implicitly(com.twitter.finagle.param.ResponseClassifier$.MODULE$.param())}));
            }

            public ServiceFactory<Req, Rep> make(Stack.Params params, ServiceFactory<Req, Rep> next2) {
                FailureAccrualFactory.Param param;
                block5: {
                    ServiceFactory<Req, Rep> serviceFactory;
                    block3: {
                        block4: {
                            block2: {
                                param = params.apply(FailureAccrualFactory$Param$.MODULE$.param());
                                if (!(param instanceof FailureAccrualFactory.Param.Configured)) break block2;
                                FailureAccrualFactory.Param.Configured configured = (FailureAccrualFactory.Param.Configured)param;
                                Function0<FailureAccrualPolicy> p = configured.failureAccrualPolicy();
                                Timer timer = params.apply(Timer$.MODULE$.param()).timer();
                                StatsReceiver statsReceiver = params.apply(Stats$.MODULE$.param()).statsReceiver();
                                String label = params.apply(Label$.MODULE$.param()).label();
                                Logger logger = params.apply(Logger$.MODULE$.param()).log();
                                PartialFunction<ReqRep, ResponseClass> classifier = params.apply(com.twitter.finagle.param.ResponseClassifier$.MODULE$.param()).responseClassifier();
                                Address endpoint = params.apply(Transporter$EndpointAddr$.MODULE$.param()).addr();
                                serviceFactory = FailureAccrualFactory$.MODULE$.wrapper(statsReceiver, (FailureAccrualPolicy)p.apply(), label, logger, endpoint, classifier, timer).andThen(next2);
                                break block3;
                            }
                            if (!(param instanceof FailureAccrualFactory.Param.Replaced)) break block4;
                            FailureAccrualFactory.Param.Replaced replaced = (FailureAccrualFactory.Param.Replaced)param;
                            Function1<Timer, ServiceFactoryWrapper> f = replaced.factory();
                            serviceFactory = ((ServiceFactoryWrapper)f.apply((Object)params.apply(Timer$.MODULE$.param()).timer())).andThen(next2);
                            break block3;
                        }
                        if (!FailureAccrualFactory$Param$Disabled$.MODULE$.equals(param)) break block5;
                        serviceFactory = next2;
                    }
                    return serviceFactory;
                }
                throw new MatchError((Object)param);
            }
            {
                this.role = FailureAccrualFactory$.MODULE$.role();
                this.description = "Backoff from hosts that we cannot successfully make requests to";
            }
        };
    }

    public <Req, Rep> String $lessinit$greater$default$5() {
        return "";
    }

    public <Req, Rep> Logger $lessinit$greater$default$6() {
        return package$.MODULE$.DefaultLogger();
    }

    public <Req, Rep> Address $lessinit$greater$default$7() {
        return Address$.MODULE$.failing();
    }

    public <Req, Rep> PartialFunction<ReqRep, ResponseClass> $lessinit$greater$default$8() {
        return ResponseClassifier$.MODULE$.Default();
    }

    private FailureAccrualFactory$() {
        MODULE$ = this;
        this.rng = new Random();
        this.defaultConsecutiveFailures = 5;
        this.jitteredBackoff = Backoff$.MODULE$.equalJittered(time$.MODULE$.intToTimeableNumber(5).seconds(), time$.MODULE$.intToTimeableNumber(300).seconds());
        this.defaultPolicy = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FailureAccrualPolicy apply() {
                return FailureAccrualPolicy$.MODULE$.consecutiveFailures(FailureAccrualFactory$.MODULE$.defaultConsecutiveFailures(), FailureAccrualFactory$.MODULE$.jitteredBackoff());
            }
        };
        this.role = new Stack.Role("FailureAccrual");
        this.Disabled = FailureAccrualFactory$Param$Disabled$.MODULE$;
    }
}

