/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.builders;

import java.io.IOException;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.AnnotationTypeWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.AbstractBuilder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.XMLNode;

public class AnnotationTypeBuilder
extends AbstractBuilder {
    public static final String ROOT = "AnnotationTypeDoc";
    private final TypeElement annotationType;
    private final AnnotationTypeWriter writer;
    private Content contentTree;

    private AnnotationTypeBuilder(AbstractBuilder.Context context, TypeElement annotationTypeElement, AnnotationTypeWriter writer) {
        super(context);
        this.annotationType = annotationTypeElement;
        this.writer = writer;
    }

    public static AnnotationTypeBuilder getInstance(AbstractBuilder.Context context, TypeElement annotationTypeDoc, AnnotationTypeWriter writer) throws Exception {
        return new AnnotationTypeBuilder(context, annotationTypeDoc, writer);
    }

    @Override
    public void build() throws IOException {
        this.build(this.layoutParser.parseXML(ROOT), this.contentTree);
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildAnnotationTypeDoc(XMLNode node, Content contentTree) throws Exception {
        contentTree = this.writer.getHeader(this.configuration.getText("doclet.AnnotationType") + " " + this.utils.getSimpleName(this.annotationType));
        Content annotationContentTree = this.writer.getAnnotationContentHeader();
        this.buildChildren(node, annotationContentTree);
        this.writer.addAnnotationContentTree(contentTree, annotationContentTree);
        this.writer.addFooter(contentTree);
        this.writer.printDocument(contentTree);
        this.writer.close();
        this.copyDocFiles();
    }

    private void copyDocFiles() {
        PackageElement containingPackage = this.utils.containingPackage(this.annotationType);
        if (this.configuration.packages == null || !this.configuration.packages.contains(containingPackage) && !this.containingPackagesSeen.contains(containingPackage)) {
            this.utils.copyDocFiles(containingPackage);
            this.containingPackagesSeen.add(containingPackage);
        }
    }

    public void buildAnnotationTypeInfo(XMLNode node, Content annotationContentTree) {
        Content annotationInfoTree = this.writer.getAnnotationInfoTreeHeader();
        this.buildChildren(node, annotationInfoTree);
        annotationContentTree.addContent(this.writer.getAnnotationInfo(annotationInfoTree));
    }

    public void buildDeprecationInfo(XMLNode node, Content annotationInfoTree) {
        this.writer.addAnnotationTypeDeprecationInfo(annotationInfoTree);
    }

    public void buildAnnotationTypeSignature(XMLNode node, Content annotationInfoTree) {
        this.writer.addAnnotationTypeSignature(this.utils.modifiersToString(this.annotationType, true), annotationInfoTree);
    }

    public void buildAnnotationTypeDescription(XMLNode node, Content annotationInfoTree) {
        this.writer.addAnnotationTypeDescription(annotationInfoTree);
    }

    public void buildAnnotationTypeTagInfo(XMLNode node, Content annotationInfoTree) {
        this.writer.addAnnotationTypeTagInfo(annotationInfoTree);
    }

    public void buildMemberSummary(XMLNode node, Content annotationContentTree) throws Exception {
        Content memberSummaryTree = this.writer.getMemberTreeHeader();
        this.configuration.getBuilderFactory().getMemberSummaryBuilder(this.writer).buildChildren(node, memberSummaryTree);
        annotationContentTree.addContent(this.writer.getMemberSummaryTree(memberSummaryTree));
    }

    public void buildAnnotationTypeMemberDetails(XMLNode node, Content annotationContentTree) {
        Content memberDetailsTree = this.writer.getMemberTreeHeader();
        this.buildChildren(node, memberDetailsTree);
        if (memberDetailsTree.isValid()) {
            annotationContentTree.addContent(this.writer.getMemberDetailsTree(memberDetailsTree));
        }
    }

    public void buildAnnotationTypeFieldDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeFieldsBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildAnnotationTypeOptionalMemberDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeOptionalMemberBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }

    public void buildAnnotationTypeRequiredMemberDetails(XMLNode node, Content memberDetailsTree) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeRequiredMemberBuilder(this.writer).buildChildren(node, memberDetailsTree);
    }
}

