/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.api;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.distributedlog.AppendOnlyStreamReader;
import org.apache.distributedlog.AppendOnlyStreamWriter;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.api.AsyncLogReader;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.api.LogWriter;
import org.apache.distributedlog.api.subscription.SubscriptionsStore;
import org.apache.distributedlog.callback.LogSegmentListener;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.namespace.NamespaceDriver;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface DistributedLogManager
extends AsyncCloseable,
Closeable {
    public String getStreamName();

    public NamespaceDriver getNamespaceDriver();

    public List<LogSegmentMetadata> getLogSegments() throws IOException;

    public void registerListener(LogSegmentListener var1) throws IOException;

    public void unregisterListener(LogSegmentListener var1);

    public CompletableFuture<AsyncLogWriter> openAsyncLogWriter();

    public LogWriter openLogWriter() throws IOException;

    public LogWriter startLogSegmentNonPartitioned() throws IOException;

    public AsyncLogWriter startAsyncLogSegmentNonPartitioned() throws IOException;

    public LogReader openLogReader(long var1) throws IOException;

    public LogReader openLogReader(DLSN var1) throws IOException;

    public CompletableFuture<AsyncLogReader> openAsyncLogReader(long var1);

    public CompletableFuture<AsyncLogReader> openAsyncLogReader(DLSN var1);

    public LogReader getInputStream(long var1) throws IOException;

    public LogReader getInputStream(DLSN var1) throws IOException;

    public AsyncLogReader getAsyncLogReader(long var1) throws IOException;

    public AsyncLogReader getAsyncLogReader(DLSN var1) throws IOException;

    public CompletableFuture<AsyncLogReader> getAsyncLogReaderWithLock(DLSN var1);

    public CompletableFuture<AsyncLogReader> getAsyncLogReaderWithLock(DLSN var1, String var2);

    public CompletableFuture<AsyncLogReader> getAsyncLogReaderWithLock(String var1);

    public AppendOnlyStreamWriter getAppendOnlyStreamWriter() throws IOException;

    public AppendOnlyStreamReader getAppendOnlyStreamReader() throws IOException;

    public CompletableFuture<DLSN> getDLSNNotLessThanTxId(long var1);

    public LogRecordWithDLSN getLastLogRecord() throws IOException;

    public CompletableFuture<LogRecordWithDLSN> getLastLogRecordAsync();

    public long getFirstTxId() throws IOException;

    public long getLastTxId() throws IOException;

    public CompletableFuture<Long> getLastTxIdAsync();

    public CompletableFuture<DLSN> getFirstDLSNAsync();

    public DLSN getLastDLSN() throws IOException;

    public CompletableFuture<DLSN> getLastDLSNAsync();

    public long getLogRecordCount() throws IOException;

    public CompletableFuture<Long> getLogRecordCountAsync(DLSN var1);

    public void recover() throws IOException;

    public boolean isEndOfStreamMarked() throws IOException;

    public void delete() throws IOException;

    public void purgeLogsOlderThan(long var1) throws IOException;

    public SubscriptionsStore getSubscriptionsStore();
}

