/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import bk-shade.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.net.BookieSocketAddress;

class RoundRobinDistributionSchedule
implements DistributionSchedule {
    private int writeQuorumSize;
    private int ackQuorumSize;
    private int ensembleSize;

    public RoundRobinDistributionSchedule(int writeQuorumSize, int ackQuorumSize, int ensembleSize) {
        this.writeQuorumSize = writeQuorumSize;
        this.ackQuorumSize = ackQuorumSize;
        this.ensembleSize = ensembleSize;
    }

    @Override
    public List<Integer> getWriteSet(long entryId) {
        ArrayList<Integer> set = new ArrayList<Integer>();
        for (int i = 0; i < this.writeQuorumSize; ++i) {
            set.add((int)((entryId + (long)i) % (long)this.ensembleSize));
        }
        return set;
    }

    @Override
    public DistributionSchedule.AckSet getAckSet() {
        final HashSet ackSet = new HashSet();
        final HashMap failureMap = new HashMap();
        return new DistributionSchedule.AckSet(){

            @Override
            public boolean completeBookieAndCheck(int bookieIndexHeardFrom) {
                failureMap.remove(bookieIndexHeardFrom);
                ackSet.add(bookieIndexHeardFrom);
                return ackSet.size() >= RoundRobinDistributionSchedule.this.ackQuorumSize;
            }

            @Override
            public boolean failBookieAndCheck(int bookieIndexHeardFrom, BookieSocketAddress address) {
                ackSet.remove(bookieIndexHeardFrom);
                failureMap.put(bookieIndexHeardFrom, address);
                return failureMap.size() > RoundRobinDistributionSchedule.this.writeQuorumSize - RoundRobinDistributionSchedule.this.ackQuorumSize;
            }

            @Override
            public Map<Integer, BookieSocketAddress> getFailedBookies() {
                return ImmutableMap.copyOf(failureMap);
            }

            @Override
            public boolean removeBookieAndCheck(int bookie) {
                ackSet.remove(bookie);
                failureMap.remove(bookie);
                return ackSet.size() >= RoundRobinDistributionSchedule.this.ackQuorumSize;
            }
        };
    }

    @Override
    public DistributionSchedule.QuorumCoverageSet getCoverageSet() {
        return new RRQuorumCoverageSet();
    }

    @Override
    public boolean hasEntry(long entryId, int bookieIndex) {
        return this.getWriteSet(entryId).contains(bookieIndex);
    }

    private class RRQuorumCoverageSet
    implements DistributionSchedule.QuorumCoverageSet {
        private final int[] covered;

        private RRQuorumCoverageSet() {
            this.covered = new int[RoundRobinDistributionSchedule.this.ensembleSize];
            for (int i = 0; i < this.covered.length; ++i) {
                this.covered[i] = 1;
            }
        }

        @Override
        public synchronized void addBookie(int bookieIndexHeardFrom, int rc) {
            this.covered[bookieIndexHeardFrom] = rc;
        }

        @Override
        public synchronized boolean checkCovered() {
            for (int i = 0; i < RoundRobinDistributionSchedule.this.ensembleSize; ++i) {
                int nodesNotCovered = 0;
                int nodesOkay = 0;
                int nodesUninitialized = 0;
                for (int j = 0; j < RoundRobinDistributionSchedule.this.writeQuorumSize; ++j) {
                    int nodeIndex = (i + j) % RoundRobinDistributionSchedule.this.ensembleSize;
                    if (this.covered[nodeIndex] == 0) {
                        ++nodesOkay;
                        continue;
                    }
                    if (this.covered[nodeIndex] != -13 && this.covered[nodeIndex] != -7) {
                        ++nodesNotCovered;
                        continue;
                    }
                    if (this.covered[nodeIndex] != 1) continue;
                    ++nodesUninitialized;
                }
                if (nodesNotCovered < RoundRobinDistributionSchedule.this.ackQuorumSize && (nodesOkay != 0 || nodesUninitialized <= 0)) continue;
                return false;
            }
            return true;
        }
    }
}

