/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieSocketAddress;

public class LedgerFragment {
    private final int bookieIndex;
    private final List<BookieSocketAddress> ensemble;
    private final long firstEntryId;
    private final long lastKnownEntryId;
    private final long ledgerId;
    private final DistributionSchedule schedule;
    private final boolean isLedgerClosed;

    LedgerFragment(LedgerHandle lh, long firstEntryId, long lastKnownEntryId, int bookieIndex) {
        this.ledgerId = lh.getId();
        this.firstEntryId = firstEntryId;
        this.lastKnownEntryId = lastKnownEntryId;
        this.bookieIndex = bookieIndex;
        this.ensemble = lh.getLedgerMetadata().getEnsemble(firstEntryId);
        this.schedule = lh.getDistributionSchedule();
        SortedMap<Long, ArrayList<BookieSocketAddress>> ensembles = lh.getLedgerMetadata().getEnsembles();
        this.isLedgerClosed = lh.getLedgerMetadata().isClosed() || !this.ensemble.equals(ensembles.get(ensembles.lastKey()));
    }

    public boolean isClosed() {
        return this.isLedgerClosed;
    }

    long getLedgerId() {
        return this.ledgerId;
    }

    long getFirstEntryId() {
        return this.firstEntryId;
    }

    long getLastKnownEntryId() {
        return this.lastKnownEntryId;
    }

    public BookieSocketAddress getAddress() {
        return this.ensemble.get(this.bookieIndex);
    }

    public int getBookiesIndex() {
        return this.bookieIndex;
    }

    public long getFirstStoredEntryId() {
        long firstEntry = this.firstEntryId;
        for (int i = 0; i < this.ensemble.size() && firstEntry <= this.lastKnownEntryId; ++firstEntry, ++i) {
            if (!this.schedule.hasEntry(firstEntry, this.bookieIndex)) continue;
            return firstEntry;
        }
        return -1L;
    }

    public long getLastStoredEntryId() {
        long lastEntry = this.lastKnownEntryId;
        for (int i = 0; i < this.ensemble.size() && lastEntry >= this.firstEntryId; --lastEntry, ++i) {
            if (!this.schedule.hasEntry(lastEntry, this.bookieIndex)) continue;
            return lastEntry;
        }
        return -1L;
    }

    public List<BookieSocketAddress> getEnsemble() {
        return this.ensemble;
    }

    public String toString() {
        return String.format("Fragment(LedgerID: %d, FirstEntryID: %d[%d], LastKnownEntryID: %d[%d], Host: %s, Closed: %s)", this.ledgerId, this.firstEntryId, this.getFirstStoredEntryId(), this.lastKnownEntryId, this.getLastStoredEntryId(), this.getAddress(), this.isLedgerClosed);
    }
}

