/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.twitter.common.base.MorePreconditions;
import com.twitter.common.stats.Rate;
import com.twitter.common.stats.Ratio;
import com.twitter.common.stats.Stat;
import com.twitter.common.stats.Stats;
import java.util.concurrent.atomic.AtomicLong;

public class SlidingStats {
    private static final int DEFAULT_WINDOW_SIZE = 1;
    private final AtomicLong total;
    private final AtomicLong events;
    private final Stat<Double> perEventLatency;

    public SlidingStats(String name, String totalUnitDisplay) {
        this(name, totalUnitDisplay, 1);
    }

    public SlidingStats(String name, String totalUnitDisplay, int windowSize) {
        MorePreconditions.checkNotBlank((String)name);
        String totalDisplay = name + "_" + totalUnitDisplay + "_total";
        String eventDisplay = name + "_events";
        this.total = Stats.exportLong(totalDisplay);
        this.events = Stats.exportLong(eventDisplay);
        this.perEventLatency = Stats.export(Ratio.of(name + "_" + totalUnitDisplay + "_per_event", Rate.of(totalDisplay + "_per_sec", this.total).withWindowSize(windowSize).build(), Rate.of(eventDisplay + "_per_sec", this.events).withWindowSize(windowSize).build()));
    }

    public AtomicLong getTotalCounter() {
        return this.total;
    }

    public AtomicLong getEventCounter() {
        return this.events;
    }

    public Stat<Double> getPerEventLatency() {
        return this.perEventLatency;
    }

    public void accumulate(long value) {
        this.total.addAndGet(value);
        this.events.incrementAndGet();
    }

    public String toString() {
        return this.total + " " + this.events;
    }
}

