/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.EphemeralType;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ZKDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerManager {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerManager.class);
    private final ZKDatabase zkDb;
    private final RequestProcessor requestProcessor;
    private final int checkIntervalMs;
    private final int maxPerMinute;
    private final Timer timer;
    private final AtomicReference<TimerTask> task = new AtomicReference<Object>(null);

    public ContainerManager(ZKDatabase zkDb, RequestProcessor requestProcessor, int checkIntervalMs, int maxPerMinute) {
        this.zkDb = zkDb;
        this.requestProcessor = requestProcessor;
        this.checkIntervalMs = checkIntervalMs;
        this.maxPerMinute = maxPerMinute;
        this.timer = new Timer("ContainerManagerTask", true);
        LOG.info(String.format("Using checkIntervalMs=%d maxPerMinute=%d", checkIntervalMs, maxPerMinute));
    }

    public void start() {
        TimerTask timerTask;
        if (this.task.get() == null && this.task.compareAndSet(null, timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    ContainerManager.this.checkContainers();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.info("interrupted");
                    this.cancel();
                }
                catch (Throwable e) {
                    LOG.error("Error checking containers", e);
                }
            }
        })) {
            this.timer.scheduleAtFixedRate(timerTask, this.checkIntervalMs, (long)this.checkIntervalMs);
        }
    }

    public void stop() {
        TimerTask timerTask = this.task.getAndSet(null);
        if (timerTask != null) {
            timerTask.cancel();
        }
        this.timer.cancel();
    }

    public void checkContainers() throws InterruptedException {
        long minIntervalMs = this.getMinIntervalMs();
        for (String containerPath : this.getCandidates()) {
            long elapsedMs;
            long waitMs;
            long startMs = Time.currentElapsedTime();
            ByteBuffer path = ByteBuffer.wrap(containerPath.getBytes());
            Request request = new Request(null, 0L, 0, 20, path, null);
            try {
                LOG.info("Attempting to delete candidate container: %s", (Object)containerPath);
                this.requestProcessor.processRequest(request);
            }
            catch (Exception e) {
                LOG.error(String.format("Could not delete container: %s", containerPath), (Throwable)e);
            }
            if ((waitMs = minIntervalMs - (elapsedMs = Time.currentElapsedTime() - startMs)) <= 0L) continue;
            Thread.sleep(waitMs);
        }
    }

    protected long getMinIntervalMs() {
        return TimeUnit.MINUTES.toMillis(1L) / (long)this.maxPerMinute;
    }

    protected Collection<String> getCandidates() {
        DataNode node;
        HashSet<String> candidates = new HashSet<String>();
        for (String containerPath : this.zkDb.getDataTree().getContainers()) {
            node = this.zkDb.getDataTree().getNode(containerPath);
            if (node == null || node.stat.getCversion() <= 0 || node.getChildren().size() != 0) continue;
            candidates.add(containerPath);
        }
        for (String ttlPath : this.zkDb.getDataTree().getTtls()) {
            Set<String> children;
            node = this.zkDb.getDataTree().getNode(ttlPath);
            if (node == null || (children = node.getChildren()) != null && children.size() != 0) continue;
            long elapsed = this.getElapsed(node);
            long ttl = EphemeralType.getTTL(node.stat.getEphemeralOwner());
            if (ttl == 0L || elapsed <= ttl) continue;
            candidates.add(ttlPath);
        }
        return candidates;
    }

    protected long getElapsed(DataNode node) {
        return Time.currentWallTime() - node.stat.getMtime();
    }
}

