/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.zookeeper.common.X509Exception;
import org.apache.zookeeper.common.ZKConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509Util {
    private static final Logger LOG = LoggerFactory.getLogger(X509Util.class);
    @Deprecated
    public static final String SSL_KEYSTORE_LOCATION = "zookeeper.ssl.keyStore.location";
    @Deprecated
    public static final String SSL_KEYSTORE_PASSWD = "zookeeper.ssl.keyStore.password";
    @Deprecated
    public static final String SSL_TRUSTSTORE_LOCATION = "zookeeper.ssl.trustStore.location";
    @Deprecated
    public static final String SSL_TRUSTSTORE_PASSWD = "zookeeper.ssl.trustStore.password";
    @Deprecated
    public static final String SSL_AUTHPROVIDER = "zookeeper.ssl.authProvider";

    public static SSLContext createSSLContext() throws X509Exception.SSLContextException {
        ZKConfig config = new ZKConfig();
        return X509Util.createSSLContext(config);
    }

    public static SSLContext createSSLContext(ZKConfig config) throws X509Exception.SSLContextException {
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        String keyStoreLocationProp = config.getProperty(SSL_KEYSTORE_LOCATION);
        String keyStorePasswordProp = config.getProperty(SSL_KEYSTORE_PASSWD);
        if (keyStoreLocationProp == null && keyStorePasswordProp == null) {
            LOG.warn("keystore not specified for client connection");
        } else {
            if (keyStoreLocationProp == null) {
                throw new X509Exception.SSLContextException("keystore location not specified for client connection");
            }
            if (keyStorePasswordProp == null) {
                throw new X509Exception.SSLContextException("keystore password not specified for client connection");
            }
            try {
                keyManagers = new KeyManager[]{X509Util.createKeyManager(keyStoreLocationProp, keyStorePasswordProp)};
            }
            catch (X509Exception.KeyManagerException e) {
                throw new X509Exception.SSLContextException("Failed to create KeyManager", e);
            }
        }
        String trustStoreLocationProp = config.getProperty(SSL_TRUSTSTORE_LOCATION);
        String trustStorePasswordProp = config.getProperty(SSL_TRUSTSTORE_PASSWD);
        if (trustStoreLocationProp == null && trustStorePasswordProp == null) {
            LOG.warn("keystore not specified for client connection");
        } else {
            if (trustStoreLocationProp == null) {
                throw new X509Exception.SSLContextException("keystore location not specified for client connection");
            }
            if (trustStorePasswordProp == null) {
                throw new X509Exception.SSLContextException("keystore password not specified for client connection");
            }
            try {
                trustManagers = new TrustManager[]{X509Util.createTrustManager(trustStoreLocationProp, trustStorePasswordProp)};
            }
            catch (X509Exception.TrustManagerException e) {
                throw new X509Exception.SSLContextException("Failed to create KeyManager", e);
            }
        }
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLSv1");
            sslContext.init(keyManagers, trustManagers, null);
        }
        catch (Exception e) {
            throw new X509Exception.SSLContextException(e);
        }
        return sslContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509KeyManager createKeyManager(String keyStoreLocation, String keyStorePassword) throws X509Exception.KeyManagerException {
        FileInputStream inputStream = null;
        try {
            char[] keyStorePasswordChars = keyStorePassword.toCharArray();
            File keyStoreFile = new File(keyStoreLocation);
            KeyStore ks = KeyStore.getInstance("JKS");
            inputStream = new FileInputStream(keyStoreFile);
            ks.load(inputStream, keyStorePasswordChars);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, keyStorePasswordChars);
            KeyManager[] arr$ = kmf.getKeyManagers();
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                KeyManager km = arr$[i$];
                if (km instanceof X509KeyManager) {
                    X509KeyManager x509KeyManager = (X509KeyManager)km;
                    return x509KeyManager;
                }
                ++i$;
            }
            throw new X509Exception.KeyManagerException("Couldn't find X509KeyManager");
        }
        catch (Exception e) {
            throw new X509Exception.KeyManagerException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509TrustManager createTrustManager(String trustStoreLocation, String trustStorePassword) throws X509Exception.TrustManagerException {
        FileInputStream inputStream = null;
        try {
            char[] trustStorePasswordChars = trustStorePassword.toCharArray();
            File trustStoreFile = new File(trustStoreLocation);
            KeyStore ts = KeyStore.getInstance("JKS");
            inputStream = new FileInputStream(trustStoreFile);
            ts.load(inputStream, trustStorePasswordChars);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ts);
            TrustManager[] arr$ = tmf.getTrustManagers();
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                TrustManager tm = arr$[i$];
                if (tm instanceof X509TrustManager) {
                    X509TrustManager x509TrustManager = (X509TrustManager)tm;
                    return x509TrustManager;
                }
                ++i$;
            }
            throw new X509Exception.TrustManagerException("Couldn't find X509TrustManager");
        }
        catch (Exception e) {
            throw new X509Exception.TrustManagerException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

