/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.zookeeper;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.twitter.common.base.Command;
import com.twitter.common.base.Commands;
import com.twitter.common.net.pool.DynamicHostSet;
import com.twitter.common.zookeeper.Group;
import com.twitter.common.zookeeper.ServerSet;
import com.twitter.common.zookeeper.ServerSets;
import com.twitter.thrift.Endpoint;
import com.twitter.thrift.ServiceInstance;
import com.twitter.thrift.Status;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StaticServerSet
implements ServerSet {
    private static final Logger LOG = Logger.getLogger(StaticServerSet.class.getName());
    private static final Function<Endpoint, ServiceInstance> ENDPOINT_TO_INSTANCE = new Function<Endpoint, ServiceInstance>(){

        public ServiceInstance apply(Endpoint endpoint) {
            return new ServiceInstance(endpoint, (Map)ImmutableMap.of(), Status.ALIVE);
        }
    };
    private final ImmutableSet<ServiceInstance> hosts;

    public StaticServerSet(Set<ServiceInstance> hosts) {
        this.hosts = ImmutableSet.copyOf(hosts);
    }

    public static StaticServerSet fromEndpoints(Set<Endpoint> endpoints) {
        return new StaticServerSet((Set<ServiceInstance>)ImmutableSet.copyOf((Iterable)Iterables.transform(endpoints, ENDPOINT_TO_INSTANCE)));
    }

    private ServerSet.EndpointStatus join(InetSocketAddress endpoint, Map<String, InetSocketAddress> auxEndpoints, Optional<Integer> shardId) {
        LOG.warning("Attempt to join fixed server set ignored.");
        ServiceInstance joining = new ServiceInstance(ServerSets.toEndpoint(endpoint), Maps.transformValues(auxEndpoints, ServerSets.TO_ENDPOINT), Status.ALIVE);
        if (shardId.isPresent()) {
            joining.setShard(((Integer)shardId.get()).intValue());
        }
        if (!this.hosts.contains((Object)joining)) {
            LOG.log(Level.SEVERE, "Joining instance " + joining + " does not match any member of the static set.");
        }
        return new ServerSet.EndpointStatus(){

            @Override
            public void leave() throws ServerSet.UpdateException {
                LOG.warning("Attempt to adjust state of fixed server set ignored.");
            }

            @Override
            public void update(Status status) throws ServerSet.UpdateException {
                LOG.warning("Attempt to adjust state of fixed server set ignored.");
            }
        };
    }

    @Override
    public ServerSet.EndpointStatus join(InetSocketAddress endpoint, Map<String, InetSocketAddress> auxEndpoints, Status status) {
        LOG.warning("This method is deprecated. Please do not specify a status field.");
        return this.join(endpoint, auxEndpoints, (Optional<Integer>)Optional.absent());
    }

    @Override
    public ServerSet.EndpointStatus join(InetSocketAddress endpoint, Map<String, InetSocketAddress> auxEndpoints) {
        LOG.warning("Joining a ServerSet without a shard ID is deprecated and will soon break.");
        return this.join(endpoint, auxEndpoints, (Optional<Integer>)Optional.absent());
    }

    @Override
    public ServerSet.EndpointStatus join(InetSocketAddress endpoint, Map<String, InetSocketAddress> auxEndpoints, int shardId) throws Group.JoinException, InterruptedException {
        return this.join(endpoint, auxEndpoints, (Optional<Integer>)Optional.of((Object)shardId));
    }

    public Command watch(DynamicHostSet.HostChangeMonitor<ServiceInstance> monitor) {
        monitor.onChange(this.hosts);
        return Commands.NOOP;
    }

    public void monitor(DynamicHostSet.HostChangeMonitor<ServiceInstance> monitor) throws DynamicHostSet.MonitorException {
        this.watch(monitor);
    }
}

