/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class Arg<T> {
    @Nullable
    private final T defaultValue;
    @Nullable
    private T value;
    private boolean hasDefault = true;
    private boolean valueApplied = false;
    private boolean valueObserved = false;

    public Arg() {
        this(null);
        this.hasDefault = false;
    }

    public Arg(@Nullable T defaultValue) {
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    synchronized void set(@Nullable T appliedValue) {
        Preconditions.checkState((!this.valueApplied ? 1 : 0) != 0, (Object)"A value cannot be applied twice to an argument.");
        Preconditions.checkState((!this.valueObserved ? 1 : 0) != 0, (Object)"A value cannot be changed after it was read.");
        this.valueApplied = true;
        this.value = appliedValue;
    }

    @VisibleForTesting
    synchronized void reset() {
        this.valueApplied = false;
        this.valueObserved = false;
        this.value = this.hasDefault ? this.defaultValue : null;
    }

    public boolean hasDefault() {
        return this.hasDefault;
    }

    @Nullable
    public synchronized T get() {
        Preconditions.checkState((this.valueApplied || this.hasDefault ? 1 : 0) != 0, (Object)"A value may only be retrieved from a variable that has a default or has been set.");
        this.valueObserved = true;
        return this.uncheckedGet();
    }

    public synchronized boolean hasAppliedValue() {
        return this.valueApplied;
    }

    @Nullable
    synchronized T uncheckedGet() {
        return this.value;
    }

    public static <T> Arg<T> create() {
        return new Arg<T>();
    }

    public static <T> Arg<T> create(@Nullable T value) {
        return new Arg<T>(value);
    }
}

