/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.serializer.writer;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.axiom.core.stream.serializer.writer.ASCIICompatibleXmlWriter;
import org.apache.axiom.core.stream.serializer.writer.UnmappableCharacterHandler;

final class Latin1XmlWriter
extends ASCIICompatibleXmlWriter {
    private final int maxChar;
    private UnmappableCharacterHandler unmappableCharacterHandler = UnmappableCharacterHandler.THROW_EXCEPTION;

    Latin1XmlWriter(OutputStream out, int maxChar) {
        super(out);
        this.maxChar = maxChar;
    }

    @Override
    public void setUnmappableCharacterHandler(UnmappableCharacterHandler unmappableCharacterHandler) throws IOException {
        this.unmappableCharacterHandler = unmappableCharacterHandler;
    }

    @Override
    protected void writeNonASCIICharacter(int codePoint) throws IOException {
        if (codePoint > this.maxChar) {
            this.unmappableCharacterHandler.processUnmappableCharacter(codePoint, this);
        } else {
            this.writeByte((byte)codePoint);
        }
    }
}

