/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.util.AxisPolicyLocator;
import org.apache.axis2.util.PolicyUtil;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.apache.neethi.PolicyRegistryImpl;

public class PolicyInclude {
    public static final int ANON_POLICY = 100;
    public static final int AXIS_POLICY = 1;
    public static final int AXIS_MODULE_POLICY = 2;
    public static final int AXIS_MODULE_OPERATION_POLICY = 17;
    public static final int AXIS_SERVICE_POLICY = 3;
    public static final int AXIS_OPERATION_POLICY = 4;
    public static final int AXIS_MESSAGE_POLICY = 5;
    public static final int SERVICE_POLICY = 6;
    public static final int PORT_POLICY = 7;
    public static final int PORT_TYPE_POLICY = 8;
    public static final int BINDING_POLICY = 9;
    public static final int OPERATION_POLICY = 10;
    public static final int BINDING_OPERATION_POLICY = 11;
    public static final int INPUT_POLICY = 12;
    public static final int OUTPUT_POLICY = 13;
    public static final int BINDING_INPUT_POLICY = 14;
    public static final int BINDING_OUTPUT_POLICY = 15;
    public static final int MESSAGE_POLICY = 16;
    private Policy policy = null;
    private Policy effectivePolicy = null;
    private PolicyRegistry reg;
    private AxisDescription description;
    private Hashtable<String, Wrapper> wrapperElements = new Hashtable();

    public PolicyInclude() {
        this.reg = new PolicyRegistryImpl();
    }

    public PolicyInclude(AxisDescription axisDescription) {
        if (axisDescription.getParent() != null) {
            PolicyInclude parentPolicyInclude = axisDescription.getParent().getPolicyInclude();
            this.reg = new PolicyRegistryImpl(parentPolicyInclude.getPolicyRegistry());
        } else {
            this.reg = new PolicyRegistryImpl();
        }
        this.setDescription(axisDescription);
    }

    public void setPolicyRegistry(PolicyRegistry reg) {
        this.reg = reg;
    }

    public PolicyRegistry getPolicyRegistry() {
        return this.reg;
    }

    public void setPolicy(Policy policy) {
        this.wrapperElements.clear();
        if (policy.getName() == null && policy.getId() == null) {
            policy.setId(UIDGenerator.generateUID());
        }
        Wrapper wrapper = new Wrapper(100, policy);
        if (policy.getName() != null) {
            this.wrapperElements.put(policy.getName(), wrapper);
        } else {
            this.wrapperElements.put(policy.getId(), wrapper);
        }
        if (this.description != null) {
            this.description.getPolicySubject().clear();
            this.description.getPolicySubject().attachPolicy(policy);
        }
    }

    public void setEffectivePolicy(Policy effectivePolicy) {
        this.effectivePolicy = effectivePolicy;
        if (this.description != null && effectivePolicy != null) {
            this.description.getPolicySubject().clear();
            this.description.getPolicySubject().attachPolicy(effectivePolicy);
        }
    }

    public void setDescription(AxisDescription description) {
        this.description = description;
    }

    public AxisDescription getDescription() {
        return this.description;
    }

    private PolicyInclude getParent() {
        if (this.description != null && this.description.getParent() != null) {
            return this.description.getParent().getPolicyInclude();
        }
        return null;
    }

    private void calculatePolicy() {
        Policy result = null;
        Iterator<Wrapper> iterator = this.wrapperElements.values().iterator();
        while (iterator.hasNext()) {
            Policy p;
            Object policyElement = iterator.next().getValue();
            if (policyElement instanceof PolicyReference) {
                AxisPolicyLocator locator = new AxisPolicyLocator(this.description);
                p = (Policy)((PolicyReference)policyElement).normalize((PolicyRegistry)locator, false);
            } else if (policyElement instanceof Policy) {
                p = (Policy)policyElement;
            } else {
                throw new RuntimeException();
            }
            result = result == null ? p : result.merge(p);
        }
        this.policy = result;
    }

    private void calculateEffectivePolicy() {
        Policy parentPolicy;
        Policy result = this.getParent() != null ? ((parentPolicy = this.getParent().getEffectivePolicy()) == null ? this.getPolicy() : (this.getPolicy() != null ? parentPolicy.merge(this.getPolicy()) : parentPolicy)) : this.getPolicy();
        this.setEffectivePolicy(result);
    }

    public Policy getPolicy() {
        if (this.description != null) {
            ArrayList<PolicyComponent> policyList = new ArrayList<PolicyComponent>(this.description.getPolicySubject().getAttachedPolicyComponents());
            return PolicyUtil.getMergedPolicy(policyList, this.description);
        }
        this.calculatePolicy();
        return this.policy;
    }

    public Policy getEffectivePolicy() {
        if (this.description != null) {
            if (this.description instanceof AxisMessage) {
                return ((AxisMessage)this.description).getEffectivePolicy();
            }
            if (this.description instanceof AxisBindingMessage) {
                return ((AxisBindingMessage)this.description).getEffectivePolicy();
            }
        }
        this.calculateEffectivePolicy();
        return this.effectivePolicy;
    }

    public ArrayList getPolicyElements(int type) {
        ArrayList<Object> policyElementList = new ArrayList<Object>();
        for (Wrapper wrapper : this.wrapperElements.values()) {
            if (wrapper.getType() != type) continue;
            policyElementList.add(wrapper.getValue());
        }
        return policyElementList;
    }

    class Wrapper {
        private int type;
        private Object value;

        Wrapper(int type, Object value) {
            this.setType(type);
            this.setValue(value);
        }

        void setType(int type) {
            this.type = type;
        }

        int getType() {
            return this.type;
        }

        void setValue(Object value) {
            this.value = value;
        }

        Object getValue() {
            return this.value;
        }
    }
}

