/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentIdGenerator;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;

public class LSMComponentIdGenerator
implements ILSMComponentIdGenerator {
    private final int numComponents;
    private int currentComponentIndex;
    private long lastUsedId;
    private ILSMComponentId componentId;

    public LSMComponentIdGenerator(int numComponents, long lastUsedId) {
        this.numComponents = numComponents;
        this.lastUsedId = lastUsedId;
        this.refresh();
        this.currentComponentIndex = 0;
    }

    @Override
    public synchronized void refresh() {
        long nextId = ++this.lastUsedId;
        this.componentId = new LSMComponentId(nextId, nextId);
        this.currentComponentIndex = (this.currentComponentIndex + 1) % this.numComponents;
    }

    @Override
    public synchronized ILSMComponentId getId() {
        return this.componentId;
    }

    @Override
    public synchronized int getCurrentComponentIndex() {
        return this.currentComponentIndex;
    }
}

