/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.assembler;

import org.apache.asterix.column.assembler.AbstractNestedValueAssembler;
import org.apache.asterix.column.assembler.AssemblerInfo;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;

public abstract class AbstractValueAssembler {
    protected static final VoidPointable NULL = new VoidPointable();
    protected static final VoidPointable MISSING;
    private final AbstractNestedValueAssembler parent;
    private final IValueReference fieldName;
    private final int fieldIndex;
    private final boolean delegate;
    protected final int level;
    protected boolean started;

    protected AbstractValueAssembler(int level, AssemblerInfo info) {
        this.parent = info.getParent();
        this.fieldName = info.getFieldName();
        this.fieldIndex = info.getFieldIndex();
        this.delegate = info.isDelegate();
        this.level = level;
    }

    abstract void addNullToAncestor(int var1) throws HyracksDataException;

    abstract void addMissingToAncestor(int var1) throws HyracksDataException;

    abstract void addValueToParent() throws HyracksDataException;

    public abstract IValueReference getValue() throws HyracksDataException;

    void reset() {
    }

    final boolean isDelegate() {
        return this.delegate;
    }

    final AbstractNestedValueAssembler getParent() {
        return this.parent;
    }

    final IValueReference getFieldName() {
        return this.fieldName;
    }

    final int getFieldIndex() {
        return this.fieldIndex;
    }

    static {
        NULL.set(new byte[]{ATypeTag.NULL.serialize()}, 0, 1);
        MISSING = new VoidPointable();
        MISSING.set(new byte[]{ATypeTag.MISSING.serialize()}, 0, 1);
    }
}

