/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.List;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class RemoveUnknownCheckForKnownTypeExpressionRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        SelectOperator selectOp = (SelectOperator)op;
        return this.processExpression(context, (ILogicalOperator)selectOp, (Mutable<ILogicalExpression>)selectOp.getCondition());
    }

    private boolean processExpressions(IOptimizationContext context, ILogicalOperator op, List<Mutable<ILogicalExpression>> expressions) throws AlgebricksException {
        boolean changed = false;
        for (Mutable<ILogicalExpression> exprRef : expressions) {
            changed |= this.processExpression(context, op, exprRef);
        }
        return changed;
    }

    private boolean processExpression(IOptimizationContext context, ILogicalOperator op, Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
        AbstractFunctionCallExpression notFuncExpr = this.getFunctionExpression(exprRef);
        if (notFuncExpr == null) {
            return false;
        }
        FunctionIdentifier fid = notFuncExpr.getFunctionIdentifier();
        if (!BuiltinFunctions.NOT.equals((Object)fid)) {
            return this.processExpressions(context, op, notFuncExpr.getArguments());
        }
        AbstractFunctionCallExpression unknownCheckFuncExpr = this.getFunctionExpression((Mutable<ILogicalExpression>)((Mutable)notFuncExpr.getArguments().get(0)));
        if (unknownCheckFuncExpr == null || !this.isNullOrIsMissingOrIsUnknownCheck(unknownCheckFuncExpr)) {
            return false;
        }
        ILogicalExpression unknownCheckArg = (ILogicalExpression)((Mutable)unknownCheckFuncExpr.getArguments().get(0)).getValue();
        IVariableTypeEnvironment env = op.computeInputTypeEnvironment((ITypingContext)context);
        IAType type = (IAType)env.getType(unknownCheckArg);
        ATypeTag typeTag = type.getTypeTag();
        if (typeTag == ATypeTag.ANY || typeTag == ATypeTag.UNION && ((AUnionType)type).isUnknownableType()) {
            return false;
        }
        exprRef.setValue((Object)ConstantExpression.TRUE);
        return true;
    }

    private boolean isNullOrIsMissingOrIsUnknownCheck(AbstractFunctionCallExpression funcExpr) {
        FunctionIdentifier fid = funcExpr.getFunctionIdentifier();
        return BuiltinFunctions.IS_NULL.equals((Object)fid) || BuiltinFunctions.IS_MISSING.equals((Object)fid) || BuiltinFunctions.IS_UNKNOWN.equals((Object)fid);
    }

    private AbstractFunctionCallExpression getFunctionExpression(Mutable<ILogicalExpression> exprRef) {
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return null;
        }
        return (AbstractFunctionCallExpression)expr;
    }
}

