/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.DataSourcePartitioningProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourcePropertiesProvider;
import org.apache.hyracks.algebricks.core.algebra.metadata.IProjectionFiltrationInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;

public abstract class DataSource
implements IDataSource<DataSourceId> {
    protected final DataSourceId id;
    protected final IAType itemType;
    protected final IAType metaItemType;
    protected final byte datasourceType;
    protected IAType[] schemaTypes;
    protected INodeDomain domain;
    protected Map<String, Serializable> properties = new HashMap<String, Serializable>();

    public DataSource(DataSourceId id, IAType itemType, IAType metaItemType, byte datasourceType, INodeDomain domain) throws AlgebricksException {
        this.id = id;
        this.itemType = itemType;
        this.metaItemType = metaItemType;
        this.datasourceType = datasourceType;
        this.domain = domain;
    }

    public IAType[] getSchemaTypes() {
        return this.schemaTypes;
    }

    public INodeDomain getDomain() {
        return this.domain;
    }

    public void computeLocalStructuralProperties(List<ILocalStructuralProperty> localProps, List<LogicalVariable> variables) {
    }

    public DataSourceId getId() {
        return this.id;
    }

    public String toString() {
        return this.id.toString();
    }

    public IDataSourcePropertiesProvider getPropertiesProvider() {
        return new DataSourcePartitioningProvider(this, this.domain);
    }

    public void computeFDs(List<LogicalVariable> scanVariables, List<FunctionalDependency> fdList) {
        int n = scanVariables.size();
        if (n > 1) {
            ArrayList<LogicalVariable> head = new ArrayList<LogicalVariable>(scanVariables.subList(0, n - 1));
            ArrayList<LogicalVariable> tail = new ArrayList<LogicalVariable>(1);
            tail.addAll(scanVariables);
            FunctionalDependency fd = new FunctionalDependency(head, tail);
            fdList.add(fd);
        }
    }

    public byte getDatasourceType() {
        return this.datasourceType;
    }

    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    public IAType getItemType() {
        return this.itemType;
    }

    public IAType getMetaItemType() {
        return this.metaItemType;
    }

    public boolean hasMeta() {
        return this.metaItemType != null;
    }

    public void setProperties(Map<String, Serializable> properties) {
        this.properties = properties;
    }

    public LogicalVariable getMetaVariable(List<LogicalVariable> dataScanVariables) {
        if (this.hasMeta()) {
            return dataScanVariables.get(dataScanVariables.size() - 1);
        }
        return null;
    }

    public LogicalVariable getDataRecordVariable(List<LogicalVariable> dataScanVariables) {
        return this.hasMeta() ? dataScanVariables.get(dataScanVariables.size() - 2) : dataScanVariables.get(dataScanVariables.size() - 1);
    }

    public List<LogicalVariable> getPrimaryKeyVariables(List<LogicalVariable> dataScanVariables) {
        return new ArrayList<LogicalVariable>(dataScanVariables.subList(0, dataScanVariables.size() - (this.hasMeta() ? 2 : 1)));
    }

    public abstract Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildDatasourceScanRuntime(MetadataProvider var1, IDataSource<DataSourceId> var2, List<LogicalVariable> var3, List<LogicalVariable> var4, boolean var5, List<LogicalVariable> var6, List<LogicalVariable> var7, ITupleFilterFactory var8, long var9, IOperatorSchema var11, IVariableTypeEnvironment var12, JobGenContext var13, JobSpecification var14, Object var15, IProjectionFiltrationInfo var16) throws AlgebricksException;

    public static class Type {
        public static final byte INTERNAL_DATASET = 0;
        public static final byte EXTERNAL_DATASET = 1;
        public static final byte FEED = 2;
        public static final byte LOADABLE = 3;
        public static final byte FUNCTION = 4;
        public static final byte SAMPLE = 5;

        private Type() {
        }
    }
}

