/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.buffermanager.IFramePool;

public class VariableFramePool
implements IFramePool {
    public static final int UNLIMITED_MEMORY = -1;
    private final IHyracksFrameMgrContext ctx;
    private final int minFrameSize;
    private final int memBudget;
    private int allocateMem;
    private ArrayList<ByteBuffer> buffers;
    private BitSet used;
    private static Comparator<ByteBuffer> sizeByteBufferComparator = new Comparator<ByteBuffer>(){

        @Override
        public int compare(ByteBuffer o1, ByteBuffer o2) {
            if (o1.capacity() == o2.capacity()) {
                return 0;
            }
            return o1.capacity() < o2.capacity() ? -1 : 1;
        }
    };

    public VariableFramePool(IHyracksFrameMgrContext ctx, int memBudgetInBytes) {
        this.ctx = ctx;
        this.minFrameSize = ctx.getInitialFrameSize();
        this.allocateMem = 0;
        if (memBudgetInBytes == -1) {
            this.memBudget = Integer.MAX_VALUE;
            this.buffers = new ArrayList();
            this.used = new BitSet();
        } else {
            this.memBudget = memBudgetInBytes;
            this.buffers = new ArrayList(memBudgetInBytes / this.minFrameSize);
            this.used = new BitSet(memBudgetInBytes / this.minFrameSize);
        }
    }

    @Override
    public int getMinFrameSize() {
        return this.minFrameSize;
    }

    @Override
    public int getMemoryBudgetBytes() {
        return this.memBudget;
    }

    @Override
    public ByteBuffer allocateFrame(int frameSize) throws HyracksDataException {
        int frameId = this.findExistingFrame(frameSize);
        if (frameId >= 0) {
            return this.reuseFrame(frameId);
        }
        if (this.haveEnoughFreeSpace(frameSize)) {
            return this.createNewFrame(frameSize);
        }
        return this.mergeExistingFrames(frameSize);
    }

    private boolean haveEnoughFreeSpace(int frameSize) {
        return frameSize + this.allocateMem <= this.memBudget;
    }

    private static int getFirstUnusedPos(BitSet used) {
        return used.nextClearBit(0);
    }

    private static int getLastUnusedPos(BitSet used, int lastPos) {
        return used.previousClearBit(lastPos);
    }

    private static int binarySearchUnusedBuffer(ArrayList<ByteBuffer> buffers, BitSet used, int frameSize) {
        ByteBuffer buffer;
        int h;
        int l = VariableFramePool.getFirstUnusedPos(used);
        if (l >= (h = VariableFramePool.getLastUnusedPos(used, buffers.size() - 1) + 1)) {
            return -1;
        }
        int highest = h;
        int mid = (l + h) / 2;
        while (l < h && (buffer = buffers.get(mid)).capacity() != frameSize) {
            if (buffer.capacity() < frameSize) {
                l = mid + 1;
            } else {
                h = mid;
            }
            mid = (l + h) / 2;
        }
        return (mid = used.nextClearBit(mid)) < highest ? mid : -1;
    }

    private int findExistingFrame(int frameSize) {
        return VariableFramePool.binarySearchUnusedBuffer(this.buffers, this.used, frameSize);
    }

    private ByteBuffer reuseFrame(int id) {
        this.used.set(id);
        this.buffers.get(id).clear();
        return this.buffers.get(id);
    }

    private ByteBuffer createNewFrame(int frameSize) throws HyracksDataException {
        this.buffers.add(this.ctx.allocateFrame(frameSize));
        this.allocateMem += frameSize;
        return this.reuseFrame(this.buffers.size() - 1);
    }

    private ByteBuffer mergeExistingFrames(int frameSize) throws HyracksDataException {
        int mergedSize = this.memBudget - this.allocateMem;
        int highBound = VariableFramePool.getLastUnusedPos(this.used, this.buffers.size() - 1) + 1;
        for (int i = VariableFramePool.getFirstUnusedPos(this.used); i < highBound; ++i) {
            if (this.used.get(i) || (mergedSize += this.deAllocateFrame(i)) < frameSize) continue;
            return this.createNewFrame(mergedSize);
        }
        return null;
    }

    private int deAllocateFrame(int id) {
        ByteBuffer frame = this.buffers.get(id);
        this.ctx.deallocateFrames(frame.capacity());
        this.buffers.set(id, null);
        this.used.set(id);
        this.allocateMem -= frame.capacity();
        return frame.capacity();
    }

    @Override
    public void reset() {
        VariableFramePool.removeEmptySpot(this.buffers);
        Collections.sort(this.buffers, sizeByteBufferComparator);
        this.used.clear();
    }

    private static void removeEmptySpot(List<ByteBuffer> buffers) {
        int i = 0;
        while (i < buffers.size()) {
            if (buffers.get(i) == null) {
                buffers.remove(i);
                continue;
            }
            ++i;
        }
    }

    @Override
    public void close() {
        this.buffers.clear();
        this.used.clear();
        this.allocateMem = 0;
    }
}

