/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve;

import java.io.IOException;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.IFieldValue;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.ParquetConverterContext;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.AbstractComplexConverter;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;

public class GenericPrimitiveConverter
extends PrimitiveConverter
implements IFieldValue {
    private final ATypeTag typeTag;
    protected final AbstractComplexConverter parent;
    protected final String stringFieldName;
    protected final IValueReference fieldName;
    protected final int index;
    protected final ParquetConverterContext context;

    GenericPrimitiveConverter(ATypeTag typeTag, AbstractComplexConverter parent, String stringFieldName, int index, ParquetConverterContext context) throws IOException {
        this.typeTag = typeTag;
        this.parent = parent;
        this.stringFieldName = stringFieldName;
        this.fieldName = context.getSerializedFieldName(stringFieldName);
        this.index = index;
        this.context = context;
    }

    @Override
    public ATypeTag getTypeTag() {
        return this.typeTag;
    }

    @Override
    public String getStringFieldName() {
        return this.stringFieldName;
    }

    @Override
    public final IValueReference getFieldName() {
        return this.fieldName;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    public void addBinary(Binary value) {
        this.context.serializeString(value, this.parent.getDataOutput());
        this.parent.addValue(this);
    }

    public void addBoolean(boolean value) {
        this.context.serializeBoolean(value, this.parent.getDataOutput());
        this.parent.addValue(this);
    }

    public void addFloat(float value) {
        this.addDouble(value);
    }

    public void addDouble(double value) {
        this.context.serializeDouble(value, this.parent.getDataOutput());
        this.parent.addValue(this);
    }

    public void addInt(int value) {
        this.addLong(value);
    }

    public void addLong(long value) {
        this.context.serializeInt64(value, this.parent.getDataOutput());
        this.parent.addValue(this);
    }
}

