/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import java.util.Set;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class SnapshotSummary {
    public static final String ADDED_FILES_PROP = "added-data-files";
    public static final String DELETED_FILES_PROP = "deleted-data-files";
    public static final String TOTAL_DATA_FILES_PROP = "total-data-files";
    public static final String ADDED_DELETE_FILES_PROP = "added-delete-files";
    public static final String ADD_EQ_DELETE_FILES_PROP = "added-equality-delete-files";
    public static final String REMOVED_EQ_DELETE_FILES_PROP = "removed-equality-delete-files";
    public static final String ADD_POS_DELETE_FILES_PROP = "added-position-delete-files";
    public static final String REMOVED_POS_DELETE_FILES_PROP = "removed-position-delete-files";
    public static final String REMOVED_DELETE_FILES_PROP = "removed-delete-files";
    public static final String TOTAL_DELETE_FILES_PROP = "total-delete-files";
    public static final String ADDED_RECORDS_PROP = "added-records";
    public static final String DELETED_RECORDS_PROP = "deleted-records";
    public static final String TOTAL_RECORDS_PROP = "total-records";
    public static final String ADDED_FILE_SIZE_PROP = "added-files-size";
    public static final String REMOVED_FILE_SIZE_PROP = "removed-files-size";
    public static final String TOTAL_FILE_SIZE_PROP = "total-files-size";
    public static final String ADDED_POS_DELETES_PROP = "added-position-deletes";
    public static final String REMOVED_POS_DELETES_PROP = "removed-position-deletes";
    public static final String TOTAL_POS_DELETES_PROP = "total-position-deletes";
    public static final String ADDED_EQ_DELETES_PROP = "added-equality-deletes";
    public static final String REMOVED_EQ_DELETES_PROP = "removed-equality-deletes";
    public static final String TOTAL_EQ_DELETES_PROP = "total-equality-deletes";
    public static final String DELETED_DUPLICATE_FILES = "deleted-duplicate-files";
    public static final String CHANGED_PARTITION_COUNT_PROP = "changed-partition-count";
    public static final String CHANGED_PARTITION_PREFIX = "partitions.";
    public static final String PARTITION_SUMMARY_PROP = "partition-summaries-included";
    public static final String STAGED_WAP_ID_PROP = "wap.id";
    public static final String PUBLISHED_WAP_ID_PROP = "published-wap-id";
    public static final String SOURCE_SNAPSHOT_ID_PROP = "source-snapshot-id";
    public static final String REPLACE_PARTITIONS_PROP = "replace-partitions";
    public static final String EXTRA_METADATA_PREFIX = "snapshot-property.";
    public static final Joiner.MapJoiner MAP_JOINER = Joiner.on((String)",").withKeyValueSeparator("=");

    private SnapshotSummary() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void setIf(boolean expression, ImmutableMap.Builder<String, String> builder, String property, Object value) {
        if (expression) {
            builder.put((Object)property, (Object)String.valueOf(value));
        }
    }

    private static class UpdateMetrics {
        private long addedSize = 0L;
        private long removedSize = 0L;
        private int addedFiles = 0;
        private int removedFiles = 0;
        private int addedEqDeleteFiles = 0;
        private int removedEqDeleteFiles = 0;
        private int addedPosDeleteFiles = 0;
        private int removedPosDeleteFiles = 0;
        private int addedDeleteFiles = 0;
        private int removedDeleteFiles = 0;
        private long addedRecords = 0L;
        private long deletedRecords = 0L;
        private long addedPosDeletes = 0L;
        private long removedPosDeletes = 0L;
        private long addedEqDeletes = 0L;
        private long removedEqDeletes = 0L;
        private boolean trustSizeAndDeleteCounts = true;

        private UpdateMetrics() {
        }

        void clear() {
            this.addedSize = 0L;
            this.removedSize = 0L;
            this.addedFiles = 0;
            this.removedFiles = 0;
            this.addedEqDeleteFiles = 0;
            this.removedEqDeleteFiles = 0;
            this.addedPosDeleteFiles = 0;
            this.removedPosDeleteFiles = 0;
            this.addedDeleteFiles = 0;
            this.removedDeleteFiles = 0;
            this.addedRecords = 0L;
            this.deletedRecords = 0L;
            this.addedPosDeletes = 0L;
            this.removedPosDeletes = 0L;
            this.addedEqDeletes = 0L;
            this.removedEqDeletes = 0L;
            this.trustSizeAndDeleteCounts = true;
        }

        void addTo(ImmutableMap.Builder<String, String> builder) {
            SnapshotSummary.setIf(this.addedFiles > 0, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.ADDED_FILES_PROP, this.addedFiles);
            SnapshotSummary.setIf(this.removedFiles > 0, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.DELETED_FILES_PROP, this.removedFiles);
            SnapshotSummary.setIf(this.addedEqDeleteFiles > 0, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.ADD_EQ_DELETE_FILES_PROP, this.addedEqDeleteFiles);
            SnapshotSummary.setIf(this.removedEqDeleteFiles > 0, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.REMOVED_EQ_DELETE_FILES_PROP, this.removedEqDeleteFiles);
            SnapshotSummary.setIf(this.addedPosDeleteFiles > 0, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.ADD_POS_DELETE_FILES_PROP, this.addedPosDeleteFiles);
            SnapshotSummary.setIf(this.removedPosDeleteFiles > 0, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.REMOVED_POS_DELETE_FILES_PROP, this.removedPosDeleteFiles);
            SnapshotSummary.setIf(this.addedDeleteFiles > 0, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.ADDED_DELETE_FILES_PROP, this.addedDeleteFiles);
            SnapshotSummary.setIf(this.removedDeleteFiles > 0, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.REMOVED_DELETE_FILES_PROP, this.removedDeleteFiles);
            SnapshotSummary.setIf(this.addedRecords > 0L, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.ADDED_RECORDS_PROP, this.addedRecords);
            SnapshotSummary.setIf(this.deletedRecords > 0L, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.DELETED_RECORDS_PROP, this.deletedRecords);
            if (this.trustSizeAndDeleteCounts) {
                SnapshotSummary.setIf(this.addedSize > 0L, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.ADDED_FILE_SIZE_PROP, this.addedSize);
                SnapshotSummary.setIf(this.removedSize > 0L, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.REMOVED_FILE_SIZE_PROP, this.removedSize);
                SnapshotSummary.setIf(this.addedPosDeletes > 0L, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.ADDED_POS_DELETES_PROP, this.addedPosDeletes);
                SnapshotSummary.setIf(this.removedPosDeletes > 0L, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.REMOVED_POS_DELETES_PROP, this.removedPosDeletes);
                SnapshotSummary.setIf(this.addedEqDeletes > 0L, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.ADDED_EQ_DELETES_PROP, this.addedEqDeletes);
                SnapshotSummary.setIf(this.removedEqDeletes > 0L, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.REMOVED_EQ_DELETES_PROP, this.removedEqDeletes);
            }
        }

        void addedFile(ContentFile<?> file) {
            this.addedSize += file.fileSizeInBytes();
            switch (file.content()) {
                case DATA: {
                    ++this.addedFiles;
                    this.addedRecords += file.recordCount();
                    break;
                }
                case POSITION_DELETES: {
                    ++this.addedDeleteFiles;
                    ++this.addedPosDeleteFiles;
                    this.addedPosDeletes += file.recordCount();
                    break;
                }
                case EQUALITY_DELETES: {
                    ++this.addedDeleteFiles;
                    ++this.addedEqDeleteFiles;
                    this.addedEqDeletes += file.recordCount();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported file content type: " + file.content());
                }
            }
        }

        void removedFile(ContentFile<?> file) {
            this.removedSize += file.fileSizeInBytes();
            switch (file.content()) {
                case DATA: {
                    ++this.removedFiles;
                    this.deletedRecords += file.recordCount();
                    break;
                }
                case POSITION_DELETES: {
                    ++this.removedDeleteFiles;
                    ++this.removedPosDeleteFiles;
                    this.removedPosDeletes += file.recordCount();
                    break;
                }
                case EQUALITY_DELETES: {
                    ++this.removedDeleteFiles;
                    ++this.removedEqDeleteFiles;
                    this.removedEqDeletes += file.recordCount();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported file content type: " + file.content());
                }
            }
        }

        void addedManifest(ManifestFile manifest) {
            switch (manifest.content()) {
                case DATA: {
                    this.addedFiles += manifest.addedFilesCount().intValue();
                    this.addedRecords += manifest.addedRowsCount().longValue();
                    this.removedFiles += manifest.deletedFilesCount().intValue();
                    this.deletedRecords += manifest.deletedRowsCount().longValue();
                    break;
                }
                case DELETES: {
                    this.addedDeleteFiles += manifest.addedFilesCount().intValue();
                    this.removedDeleteFiles += manifest.deletedFilesCount().intValue();
                    this.trustSizeAndDeleteCounts = false;
                }
            }
        }

        void merge(UpdateMetrics other) {
            this.addedFiles += other.addedFiles;
            this.removedFiles += other.removedFiles;
            this.addedEqDeleteFiles += other.addedEqDeleteFiles;
            this.removedEqDeleteFiles += other.removedEqDeleteFiles;
            this.addedPosDeleteFiles += other.addedPosDeleteFiles;
            this.removedPosDeleteFiles += other.removedPosDeleteFiles;
            this.addedDeleteFiles += other.addedDeleteFiles;
            this.removedDeleteFiles += other.removedDeleteFiles;
            this.addedSize += other.addedSize;
            this.removedSize += other.removedSize;
            this.addedRecords += other.addedRecords;
            this.deletedRecords += other.deletedRecords;
            this.addedPosDeletes += other.addedPosDeletes;
            this.removedPosDeletes += other.removedPosDeletes;
            this.addedEqDeletes += other.addedEqDeletes;
            this.removedEqDeletes += other.removedEqDeletes;
            this.trustSizeAndDeleteCounts = this.trustSizeAndDeleteCounts && other.trustSizeAndDeleteCounts;
        }
    }

    public static class Builder {
        private final Map<String, String> properties = Maps.newHashMap();
        private final Map<String, UpdateMetrics> partitionMetrics = Maps.newHashMap();
        private final UpdateMetrics metrics = new UpdateMetrics();
        private int maxChangedPartitionsForSummaries = 0;
        private long deletedDuplicateFiles = 0L;
        private boolean trustPartitionMetrics = true;

        private Builder() {
        }

        public void clear() {
            this.partitionMetrics.clear();
            this.metrics.clear();
            this.deletedDuplicateFiles = 0L;
            this.trustPartitionMetrics = true;
        }

        public void setPartitionSummaryLimit(int max) {
            this.maxChangedPartitionsForSummaries = max;
        }

        public void incrementDuplicateDeletes() {
            ++this.deletedDuplicateFiles;
        }

        public void incrementDuplicateDeletes(int increment) {
            this.deletedDuplicateFiles += (long)increment;
        }

        public void addedFile(PartitionSpec spec, DataFile file) {
            this.metrics.addedFile((ContentFile<?>)file);
            this.updatePartitions(spec, (ContentFile<?>)file, true);
        }

        public void addedFile(PartitionSpec spec, DeleteFile file) {
            this.metrics.addedFile((ContentFile<?>)file);
            this.updatePartitions(spec, (ContentFile<?>)file, true);
        }

        public void deletedFile(PartitionSpec spec, ContentFile<?> file) {
            if (file instanceof DataFile) {
                this.deletedFile(spec, (DataFile)file);
            } else if (file instanceof DeleteFile) {
                this.deletedFile(spec, (DeleteFile)file);
            } else {
                throw new IllegalArgumentException("Unsupported file type: " + file.getClass().getSimpleName());
            }
        }

        public void deletedFile(PartitionSpec spec, DataFile file) {
            this.metrics.removedFile((ContentFile<?>)file);
            this.updatePartitions(spec, (ContentFile<?>)file, false);
        }

        public void deletedFile(PartitionSpec spec, DeleteFile file) {
            this.metrics.removedFile((ContentFile<?>)file);
            this.updatePartitions(spec, (ContentFile<?>)file, false);
        }

        public void addedManifest(ManifestFile manifest) {
            this.trustPartitionMetrics = false;
            this.partitionMetrics.clear();
            this.metrics.addedManifest(manifest);
        }

        public void set(String property, String value) {
            this.properties.put(property, value);
        }

        private void updatePartitions(PartitionSpec spec, ContentFile<?> file, boolean isAddition) {
            if (this.trustPartitionMetrics) {
                UpdateMetrics partMetrics = this.partitionMetrics.computeIfAbsent(spec.partitionToPath(file.partition()), key -> new UpdateMetrics());
                if (isAddition) {
                    partMetrics.addedFile(file);
                } else {
                    partMetrics.removedFile(file);
                }
            }
        }

        public void merge(Builder builder) {
            this.properties.putAll(builder.properties);
            this.metrics.merge(builder.metrics);
            boolean bl = this.trustPartitionMetrics = this.trustPartitionMetrics && builder.trustPartitionMetrics;
            if (this.trustPartitionMetrics) {
                for (Map.Entry<String, UpdateMetrics> entry : builder.partitionMetrics.entrySet()) {
                    this.partitionMetrics.computeIfAbsent(entry.getKey(), key -> new UpdateMetrics()).merge(entry.getValue());
                }
            } else {
                this.partitionMetrics.clear();
            }
            this.deletedDuplicateFiles += builder.deletedDuplicateFiles;
        }

        public Map<String, String> build() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.putAll(this.properties);
            this.metrics.addTo((ImmutableMap.Builder<String, String>)builder);
            SnapshotSummary.setIf(this.deletedDuplicateFiles > 0L, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.DELETED_DUPLICATE_FILES, this.deletedDuplicateFiles);
            Set<String> changedPartitions = this.partitionMetrics.keySet();
            SnapshotSummary.setIf(this.trustPartitionMetrics, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.CHANGED_PARTITION_COUNT_PROP, changedPartitions.size());
            if (this.trustPartitionMetrics && changedPartitions.size() <= this.maxChangedPartitionsForSummaries) {
                SnapshotSummary.setIf(changedPartitions.size() > 0, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.PARTITION_SUMMARY_PROP, "true");
                for (String key : changedPartitions) {
                    SnapshotSummary.setIf(key != null, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.CHANGED_PARTITION_PREFIX + key, Builder.partitionSummary(this.partitionMetrics.get(key)));
                }
            }
            return builder.build();
        }

        private static String partitionSummary(UpdateMetrics metrics) {
            ImmutableMap.Builder partBuilder = ImmutableMap.builder();
            metrics.addTo((ImmutableMap.Builder<String, String>)partBuilder);
            return MAP_JOINER.join((Map)partBuilder.build());
        }
    }
}

