/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.resource.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import io.opencensus.contrib.resource.util.GcpMetadataConfig;
import io.opencensus.resource.Resource;
import java.util.LinkedHashMap;
import java.util.List;

public class K8sResource {
    public static final String TYPE = "k8s";
    public static final String CLUSTER_NAME_KEY = "k8s.cluster.name";
    public static final String NAMESPACE_NAME_KEY = "k8s.namespace.name";
    public static final String POD_NAME_KEY = "k8s.pod.name";
    public static final String DEPLOYMENT_NAME_KEY = "k8s.deployment.name";
    private static final Splitter splitter = Splitter.on((char)'-');

    @Deprecated
    public static Resource create(String clusterName, String namespace, String podName) {
        return K8sResource.create(clusterName, namespace, podName, "");
    }

    public static Resource create(String clusterName, String namespace, String podName, String deploymentName) {
        LinkedHashMap<String, Object> labels = new LinkedHashMap<String, Object>();
        labels.put(CLUSTER_NAME_KEY, Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName"));
        labels.put(NAMESPACE_NAME_KEY, Preconditions.checkNotNull((Object)namespace, (Object)"namespace"));
        labels.put(POD_NAME_KEY, Preconditions.checkNotNull((Object)podName, (Object)"podName"));
        labels.put(DEPLOYMENT_NAME_KEY, Preconditions.checkNotNull((Object)deploymentName, (Object)"deploymentName"));
        return Resource.create((String)TYPE, labels);
    }

    static Resource detect() {
        String podName = (String)MoreObjects.firstNonNull((Object)System.getenv("HOSTNAME"), (Object)"");
        String deploymentName = K8sResource.getDeploymentNameFromPodName(podName);
        return K8sResource.create(GcpMetadataConfig.getClusterName(), (String)MoreObjects.firstNonNull((Object)System.getenv("NAMESPACE"), (Object)""), podName, deploymentName);
    }

    @VisibleForTesting
    static String getDeploymentNameFromPodName(String podName) {
        StringBuilder deploymentName = new StringBuilder();
        List parts = splitter.splitToList((CharSequence)podName);
        if (parts.size() == 3) {
            deploymentName.append((String)parts.get(0));
        } else if (parts.size() > 3) {
            for (int i = 0; i < parts.size() - 2; ++i) {
                if (deploymentName.length() > 0) {
                    deploymentName.append('-');
                }
                deploymentName.append((String)parts.get(i));
            }
        }
        return deploymentName.toString();
    }

    private K8sResource() {
    }
}

