/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.resource;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.dataflow.DatasetLocalResource;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.replication.AllDatasetsReplicationStrategy;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.replication.ReplicationJob;
import org.apache.asterix.common.storage.DatasetCopyIdentifier;
import org.apache.asterix.common.storage.DatasetResourceReference;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.common.storage.ResourceStorageStats;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;
import org.apache.hyracks.storage.common.ILocalResourceRepository;
import org.apache.hyracks.storage.common.LocalResource;
import org.apache.hyracks.util.ExitUtil;
import org.apache.hyracks.util.file.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PersistentLocalResourceRepository
implements ILocalResourceRepository {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String METADATA_FILE_MASK_NAME = ".mask_.metadata";
    private static final FilenameFilter LSM_INDEX_FILES_FILTER = (dir, name) -> name.startsWith(".metadata") || !name.startsWith(".");
    private static final FilenameFilter MASK_FILES_FILTER = (dir, name) -> name.startsWith(".mask_");
    private static final int MAX_CACHED_RESOURCES = 1000;
    private static final FilenameFilter METADATA_FILES_FILTER = (dir, name) -> name.equals(".metadata");
    private static final FilenameFilter METADATA_MASK_FILES_FILTER = (dir, name) -> name.equals(METADATA_FILE_MASK_NAME);
    private final IIOManager ioManager;
    private final Cache<String, LocalResource> resourceCache;
    private boolean isReplicationEnabled = false;
    private Set<String> filesToBeReplicated;
    private IReplicationManager replicationManager;
    private final List<Path> storageRoots;
    private final IIndexCheckpointManagerProvider indexCheckpointManagerProvider;
    private final IPersistedResourceRegistry persistedResourceRegistry;
    private IDatasetLifecycleManager datasetLifecycleManager;

    public PersistentLocalResourceRepository(IIOManager ioManager, IIndexCheckpointManagerProvider indexCheckpointManagerProvider, IPersistedResourceRegistry persistedResourceRegistry) {
        this.ioManager = ioManager;
        this.indexCheckpointManagerProvider = indexCheckpointManagerProvider;
        this.persistedResourceRegistry = persistedResourceRegistry;
        this.storageRoots = new ArrayList<Path>();
        List ioDevices = ioManager.getIODevices();
        for (int i = 0; i < ioDevices.size(); ++i) {
            this.storageRoots.add(Paths.get(((IODeviceHandle)ioDevices.get(i)).getMount().getAbsolutePath(), "storage"));
        }
        this.createStorageRoots();
        this.resourceCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    }

    public String toString() {
        StringBuilder aString = new StringBuilder().append(PersistentLocalResourceRepository.class.getSimpleName()).append(13).append(this.ioManager.getClass().getSimpleName()).append(':').append(13).append(this.ioManager.toString()).append(13).append("Cached Resources:").append(13);
        this.resourceCache.asMap().forEach((key, value) -> aString.append((String)key).append("->").append(value).append(13));
        return aString.toString();
    }

    public synchronized LocalResource get(String relativePath) throws HyracksDataException {
        FileReference resourceFile;
        LocalResource resource = (LocalResource)this.resourceCache.getIfPresent((Object)relativePath);
        if (resource == null && (resourceFile = PersistentLocalResourceRepository.getLocalResourceFileByName(this.ioManager, relativePath)).getFile().exists()) {
            resource = this.readLocalResource(resourceFile.getFile());
            this.resourceCache.put((Object)relativePath, (Object)resource);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(LocalResource resource) throws HyracksDataException {
        FileReference resourceFile;
        PersistentLocalResourceRepository persistentLocalResourceRepository = this;
        synchronized (persistentLocalResourceRepository) {
            String relativePath = PersistentLocalResourceRepository.getFileName(resource.getPath());
            resourceFile = this.ioManager.resolve(relativePath);
            if (resourceFile.getFile().exists()) {
                throw new HyracksDataException("Duplicate resource: " + resourceFile.getAbsolutePath());
            }
            File parent = resourceFile.getFile().getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_CREATE_FILE, (Serializable[])new Serializable[]{parent.getAbsolutePath()});
            }
            try {
                this.createResourceFileMask(resourceFile);
                byte[] bytes = OBJECT_MAPPER.writeValueAsBytes((Object)resource.toJson(this.persistedResourceRegistry));
                FileUtil.writeAndForce((Path)Paths.get(resourceFile.getAbsolutePath(), new String[0]), (byte[])bytes);
                this.indexCheckpointManagerProvider.get((ResourceReference)DatasetResourceReference.of((LocalResource)resource)).init(-1L, 0L, LSMComponentId.EMPTY_INDEX_LAST_COMPONENT_ID.getMaxId(), null);
                this.deleteResourceFileMask(resourceFile);
            }
            catch (Exception e) {
                this.cleanup(resourceFile);
                throw HyracksDataException.create((Throwable)e);
            }
            catch (Throwable th) {
                LOGGER.error("Error creating resource {}", (Object)resourceFile, (Object)th);
                ExitUtil.halt((int)13);
            }
            this.resourceCache.put((Object)resource.getPath(), (Object)resource);
        }
        if (this.isReplicationEnabled) {
            try {
                this.createReplicationJob(IReplicationJob.ReplicationOperation.REPLICATE, resourceFile);
            }
            catch (Exception e) {
                LOGGER.error("failed to send resource file {} to replicas", (Object)resourceFile);
            }
        }
    }

    private void cleanup(FileReference resourceFile) {
        if (resourceFile.getFile().exists()) {
            try {
                IoUtil.delete((FileReference)resourceFile);
            }
            catch (Throwable th) {
                LOGGER.error("Error cleaning up corrupted resource {}", (Object)resourceFile, (Object)th);
                ExitUtil.halt((int)12);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String relativePath) throws HyracksDataException {
        FileReference resourceFile = PersistentLocalResourceRepository.getLocalResourceFileByName(this.ioManager, relativePath);
        boolean resourceExists = resourceFile.getFile().exists();
        if (resourceExists) {
            try {
                this.createReplicationJob(IReplicationJob.ReplicationOperation.DELETE, resourceFile);
            }
            catch (Exception e) {
                LOGGER.error("failed to delete resource file {} from replicas", (Object)resourceFile);
            }
        }
        PersistentLocalResourceRepository persistentLocalResourceRepository = this;
        synchronized (persistentLocalResourceRepository) {
            block10: {
                try {
                    if (resourceExists) {
                        LocalResource localResource = this.readLocalResource(resourceFile.getFile());
                        IoUtil.delete((FileReference)resourceFile);
                        this.indexCheckpointManagerProvider.get((ResourceReference)DatasetResourceReference.of((LocalResource)localResource)).delete();
                        break block10;
                    }
                    throw HyracksDataException.create((ErrorCode)ErrorCode.RESOURCE_DOES_NOT_EXIST, (Serializable[])new Serializable[]{relativePath});
                }
                finally {
                    this.invalidateResource(relativePath);
                }
            }
        }
    }

    public static FileReference getLocalResourceFileByName(IIOManager ioManager, String resourcePath) throws HyracksDataException {
        String fileName = resourcePath + File.separator + ".metadata";
        return ioManager.resolve(fileName);
    }

    public synchronized Map<Long, LocalResource> getResources(Predicate<LocalResource> filter, List<Path> roots) throws HyracksDataException {
        HashMap<Long, LocalResource> resourcesMap = new HashMap<Long, LocalResource>();
        for (Path root : roots) {
            if (!Files.exists(root, new LinkOption[0]) || !Files.isDirectory(root, new LinkOption[0])) continue;
            Collection files = IoUtil.getMatchingFiles((Path)root, (FilenameFilter)METADATA_FILES_FILTER);
            try {
                for (File file : files) {
                    LocalResource duplicate;
                    LocalResource localResource = this.readLocalResource(file);
                    if (!filter.test(localResource) || (duplicate = resourcesMap.putIfAbsent(localResource.getId(), localResource)) == null) continue;
                    LOGGER.warn("found duplicate resource ids {} and {}", (Object)localResource, (Object)duplicate);
                }
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        return resourcesMap;
    }

    public synchronized Map<Long, LocalResource> getResources(Predicate<LocalResource> filter) throws HyracksDataException {
        return this.getResources(filter, this.storageRoots);
    }

    public synchronized Map<Long, LocalResource> getResources(Predicate<LocalResource> filter, Set<Integer> partitions) throws HyracksDataException {
        ArrayList<Path> partitionsRoots = new ArrayList<Path>();
        for (Integer partition : partitions) {
            partitionsRoots.add(this.getPartitionRoot(partition));
        }
        return this.getResources(filter, partitionsRoots);
    }

    public synchronized void deleteInvalidIndexes(Predicate<LocalResource> filter) throws HyracksDataException {
        for (Path root : this.storageRoots) {
            Collection files = IoUtil.getMatchingFiles((Path)root, (FilenameFilter)METADATA_FILES_FILTER);
            try {
                for (File file : files) {
                    LocalResource localResource = this.readLocalResource(file);
                    if (!filter.test(localResource)) continue;
                    LOGGER.warn("deleting invalid metadata index {}", (Object)file.getParentFile());
                    IoUtil.delete((File)file.getParentFile());
                }
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        this.resourceCache.invalidateAll();
    }

    public Map<Long, LocalResource> loadAndGetAllResources() throws HyracksDataException {
        return this.getResources(p -> true);
    }

    public synchronized long maxId() throws HyracksDataException {
        Map<Long, LocalResource> allResources = this.loadAndGetAllResources();
        Optional max = allResources.keySet().stream().max(Long::compare);
        return max.isPresent() ? (Long)max.get() : 0L;
    }

    public void invalidateResource(String relativePath) {
        this.resourceCache.invalidate((Object)relativePath);
    }

    public void clearResourcesCache() {
        this.resourceCache.invalidateAll();
    }

    private static String getFileName(String path) {
        return path.endsWith(File.separator) ? path + ".metadata" : path + File.separator + ".metadata";
    }

    private LocalResource readLocalResource(File file) throws HyracksDataException {
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        try {
            JsonNode jsonNode = (JsonNode)OBJECT_MAPPER.readValue(Files.readAllBytes(path), JsonNode.class);
            LocalResource resource = (LocalResource)this.persistedResourceRegistry.deserialize(jsonNode);
            if (resource.getVersion() == 7) {
                return resource;
            }
            throw new AsterixException("Storage version mismatch.");
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public synchronized void setReplicationManager(IReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
        this.isReplicationEnabled = replicationManager.isReplicationEnabled();
        if (this.isReplicationEnabled) {
            this.filesToBeReplicated = new HashSet<String>();
        }
    }

    public void setDatasetLifecycleManager(IDatasetLifecycleManager datasetLifecycleManager) {
        this.datasetLifecycleManager = datasetLifecycleManager;
    }

    private void createReplicationJob(IReplicationJob.ReplicationOperation operation, FileReference fileRef) throws HyracksDataException {
        this.filesToBeReplicated.clear();
        this.filesToBeReplicated.add(fileRef.getAbsolutePath());
        ReplicationJob job = new ReplicationJob(IReplicationJob.ReplicationJobType.METADATA, operation, IReplicationJob.ReplicationExecutionType.SYNC, this.filesToBeReplicated);
        try {
            this.replicationManager.submitJob((IReplicationJob)job);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public synchronized void deleteStorageData() throws IOException {
        for (Path root : this.storageRoots) {
            File rootFile = root.toFile();
            if (!rootFile.exists()) continue;
            FileUtils.deleteDirectory((File)rootFile);
        }
        this.createStorageRoots();
    }

    public synchronized Set<Integer> getAllPartitions() throws HyracksDataException {
        return this.loadAndGetAllResources().values().stream().map(LocalResource::getResource).map(DatasetLocalResource.class::cast).map(DatasetLocalResource::getPartition).collect(Collectors.toSet());
    }

    public synchronized Optional<DatasetResourceReference> getLocalResourceReference(String absoluteFilePath) throws HyracksDataException {
        String localResourcePath = StoragePathUtil.getIndexFileRelativePath((String)absoluteFilePath);
        LocalResource lr = this.get(localResourcePath);
        return lr != null ? Optional.of(DatasetResourceReference.of((LocalResource)lr)) : Optional.empty();
    }

    public synchronized Set<File> getPartitionIndexes(int partition) throws HyracksDataException {
        Path partitionRoot = this.getPartitionRoot(partition);
        Map<Long, LocalResource> partitionResourcesMap = this.getResources((LocalResource resource) -> {
            DatasetLocalResource dsResource = (DatasetLocalResource)resource.getResource();
            return dsResource.getPartition() == partition;
        }, Collections.singletonList(partitionRoot));
        HashSet<File> indexes = new HashSet<File>();
        for (LocalResource localResource : partitionResourcesMap.values()) {
            indexes.add(this.ioManager.resolve(localResource.getPath()).getFile());
        }
        return indexes;
    }

    public synchronized Map<Long, LocalResource> getPartitionResources(int partition) throws HyracksDataException {
        return this.getResources((LocalResource r) -> true, Collections.singleton(partition));
    }

    public synchronized Map<String, Long> getPartitionReplicatedResources(int partition, IReplicationStrategy strategy) throws HyracksDataException {
        HashMap<String, Long> partitionReplicatedResources = new HashMap<String, Long>();
        Map<Long, LocalResource> partitionResources = this.getPartitionResources(partition);
        for (LocalResource lr : partitionResources.values()) {
            DatasetLocalResource datasetLocalResource = (DatasetLocalResource)lr.getResource();
            if (!strategy.isMatch(datasetLocalResource.getDatasetId())) continue;
            DatasetResourceReference drr = DatasetResourceReference.of((LocalResource)lr);
            partitionReplicatedResources.put(drr.getFileRelativePath().toString(), lr.getId());
        }
        return partitionReplicatedResources;
    }

    public synchronized List<String> getPartitionReplicatedFiles(int partition, IReplicationStrategy strategy) throws HyracksDataException {
        ArrayList<String> partitionReplicatedFiles = new ArrayList<String>();
        HashSet<File> replicatedIndexes = new HashSet<File>();
        Map<Long, LocalResource> partitionResources = this.getPartitionResources(partition);
        for (LocalResource lr : partitionResources.values()) {
            DatasetLocalResource datasetLocalResource = (DatasetLocalResource)lr.getResource();
            if (!strategy.isMatch(datasetLocalResource.getDatasetId())) continue;
            replicatedIndexes.add(this.ioManager.resolve(lr.getPath()).getFile());
        }
        for (File indexDir : replicatedIndexes) {
            partitionReplicatedFiles.addAll(this.getIndexFiles(indexDir));
        }
        return partitionReplicatedFiles;
    }

    public synchronized long getReplicatedIndexesMaxComponentId(int partition, IReplicationStrategy strategy) throws HyracksDataException {
        long maxComponentId = 0L;
        Map<Long, LocalResource> partitionResources = this.getPartitionResources(partition);
        for (LocalResource lr : partitionResources.values()) {
            DatasetLocalResource datasetLocalResource = (DatasetLocalResource)lr.getResource();
            if (!strategy.isMatch(datasetLocalResource.getDatasetId())) continue;
            IIndexCheckpointManager indexCheckpointManager = this.indexCheckpointManagerProvider.get((ResourceReference)DatasetResourceReference.of((LocalResource)lr));
            maxComponentId = Math.max(maxComponentId, indexCheckpointManager.getLatest().getLastComponentId());
        }
        return maxComponentId;
    }

    private List<String> getIndexFiles(File indexDir) {
        File[] indexFilteredFiles;
        ArrayList<String> indexFiles = new ArrayList<String>();
        if (indexDir.isDirectory() && (indexFilteredFiles = indexDir.listFiles(LSM_INDEX_FILES_FILTER)) != null) {
            Stream.of(indexFilteredFiles).map(File::getAbsolutePath).forEach(indexFiles::add);
        }
        return indexFiles;
    }

    private void createStorageRoots() {
        for (Path root : this.storageRoots) {
            try {
                Files.createDirectories(root, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create storage root directory at " + root, e);
            }
        }
    }

    public synchronized void cleanup(int partition) throws HyracksDataException {
        this.datasetLifecycleManager.waitForIO(AllDatasetsReplicationStrategy.INSTANCE, partition);
        Set<File> partitionIndexes = this.getPartitionIndexes(partition);
        try {
            for (File index : partitionIndexes) {
                this.deleteIndexMaskedFiles(index);
                if (!this.isValidIndex(index)) continue;
                this.deleteIndexInvalidComponents(index);
            }
        }
        catch (IOException | ParseException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public List<ResourceStorageStats> getStorageStats() throws HyracksDataException {
        List allResources = this.loadAndGetAllResources().values().stream().map(DatasetResourceReference::of).collect(Collectors.toList());
        ArrayList<ResourceStorageStats> resourcesStats = new ArrayList<ResourceStorageStats>();
        for (DatasetResourceReference res : allResources) {
            ResourceStorageStats resourceStats = this.getResourceStats(res);
            if (resourceStats == null) continue;
            resourcesStats.add(resourceStats);
        }
        return resourcesStats;
    }

    public synchronized void deleteCorruptedResources() throws HyracksDataException {
        for (Path root : this.storageRoots) {
            Collection metadataMaskFiles = IoUtil.getMatchingFiles((Path)root, (FilenameFilter)METADATA_MASK_FILES_FILTER);
            for (File metadataMaskFile : metadataMaskFiles) {
                File resourceFile = new File(metadataMaskFile.getParent(), ".metadata");
                if (resourceFile.exists()) {
                    IoUtil.delete((File)resourceFile);
                }
                IoUtil.delete((File)metadataMaskFile);
            }
        }
    }

    private void deleteIndexMaskedFiles(File index) throws IOException {
        File[] masks = index.listFiles(MASK_FILES_FILTER);
        if (masks != null) {
            for (File mask : masks) {
                this.deleteIndexMaskedFiles(index, mask);
                Files.delete(mask.toPath());
            }
        }
    }

    private boolean isValidIndex(File index) throws IOException {
        return this.getIndexCheckpointManager(index).getCheckpointCount() != 0;
    }

    private void deleteIndexInvalidComponents(File index) throws IOException, ParseException {
        File[] indexComponentFiles = index.listFiles(AbstractLSMIndexFileManager.COMPONENT_FILES_FILTER);
        if (indexComponentFiles == null) {
            throw new IOException(index + " doesn't exist or an IO error occurred");
        }
        long validComponentSequence = this.getIndexCheckpointManager(index).getValidComponentSequence();
        for (File componentFile : indexComponentFiles) {
            long fileStart = IndexComponentFileReference.of((String)componentFile.getName()).getSequenceStart();
            long fileEnd = IndexComponentFileReference.of((String)componentFile.getName()).getSequenceEnd();
            if (fileStart <= validComponentSequence && fileEnd <= validComponentSequence) continue;
            LOGGER.warn(() -> "Deleting invalid component file " + componentFile.getAbsolutePath() + " based on valid sequence " + validComponentSequence);
            Files.delete(componentFile.toPath());
        }
    }

    private IIndexCheckpointManager getIndexCheckpointManager(File index) throws HyracksDataException {
        String indexFile = Paths.get(index.getAbsolutePath(), ".metadata").toString();
        ResourceReference indexRef = ResourceReference.of((String)indexFile);
        return this.indexCheckpointManagerProvider.get(indexRef);
    }

    private void deleteIndexMaskedFiles(File index, File mask) throws IOException {
        File[] maskedFiles;
        if (!mask.getName().startsWith(".mask_")) {
            throw new IllegalArgumentException("Unrecognized mask file: " + mask);
        }
        if (PersistentLocalResourceRepository.isComponentMask(mask)) {
            String componentId = mask.getName().substring(".mask_C_".length());
            maskedFiles = index.listFiles((dir, name) -> name.startsWith(componentId));
        } else {
            String maskedFileName = mask.getName().substring(".mask_".length());
            maskedFiles = index.listFiles((dir, name) -> name.equals(maskedFileName));
        }
        if (maskedFiles != null) {
            for (File maskedFile : maskedFiles) {
                LOGGER.info(() -> "deleting masked file: " + maskedFile.getAbsolutePath());
                Files.delete(maskedFile.toPath());
            }
        }
    }

    private ResourceStorageStats getResourceStats(DatasetResourceReference resource) {
        try {
            FileReference resolvedPath = this.ioManager.resolve(resource.getRelativePath().toString());
            long totalSize = 0L;
            File[] indexFiles = resolvedPath.getFile().listFiles();
            HashMap<String, Long> componentsStats = new HashMap<String, Long>();
            if (indexFiles != null) {
                for (File file : indexFiles) {
                    long fileSize = file.length();
                    totalSize += fileSize;
                    if (!PersistentLocalResourceRepository.isComponentFile(resolvedPath.getFile(), file.getName())) continue;
                    String componentSeq = ResourceReference.getComponentSequence((String)file.getAbsolutePath());
                    componentsStats.put(componentSeq, componentsStats.getOrDefault(componentSeq, 0L) + fileSize);
                }
            }
            return new ResourceStorageStats(resource, componentsStats, totalSize);
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't get stats for resource {}", (Object)resource.getRelativePath(), (Object)e);
            return null;
        }
    }

    public long getDatasetSize(DatasetCopyIdentifier datasetIdentifier, Set<Integer> nodePartitions) throws HyracksDataException {
        long totalSize = 0L;
        Map<Long, LocalResource> dataverse = this.getResources((LocalResource lr) -> {
            ResourceReference resourceReference = ResourceReference.ofIndex((String)lr.getPath());
            return datasetIdentifier.isMatch(resourceReference);
        }, nodePartitions);
        List allResources = dataverse.values().stream().map(DatasetResourceReference::of).collect(Collectors.toList());
        for (DatasetResourceReference res : allResources) {
            ResourceStorageStats resourceStats = this.getResourceStats(res);
            if (resourceStats == null) continue;
            totalSize += resourceStats.getTotalSize();
        }
        return totalSize;
    }

    private void createResourceFileMask(FileReference resourceFile) throws HyracksDataException {
        Path maskFile = this.getResourceMaskFilePath(resourceFile);
        try {
            Files.createFile(maskFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void deleteResourceFileMask(FileReference resourceFile) throws HyracksDataException {
        Path maskFile = this.getResourceMaskFilePath(resourceFile);
        IoUtil.delete((Path)maskFile);
    }

    private Path getResourceMaskFilePath(FileReference resourceFile) {
        return Paths.get(resourceFile.getFile().getParentFile().getAbsolutePath(), METADATA_FILE_MASK_NAME);
    }

    private static boolean isComponentMask(File mask) {
        return mask.getName().startsWith(".mask_C_");
    }

    private static boolean isComponentFile(File indexDir, String fileName) {
        return AbstractLSMIndexFileManager.COMPONENT_FILES_FILTER.accept(indexDir, fileName);
    }

    public List<Path> getStorageRoots() {
        return this.storageRoots;
    }

    public synchronized void keepPartitions(Set<Integer> keepPartitions) {
        List<File> onDiskPartitions = this.getOnDiskPartitions();
        for (File onDiskPartition : onDiskPartitions) {
            int partitionNum = StoragePathUtil.getPartitionNumFromRelativePath((String)onDiskPartition.getAbsolutePath());
            if (keepPartitions.contains(partitionNum)) continue;
            LOGGER.warn("deleting partition {} since it is not on partitions to keep {}", (Object)partitionNum, keepPartitions);
            FileUtils.deleteQuietly((File)onDiskPartition);
        }
    }

    public synchronized List<File> getOnDiskPartitions() {
        ArrayList<File> onDiskPartitions = new ArrayList<File>();
        for (Path root : this.storageRoots) {
            File[] partitions = root.toFile().listFiles((dir, name) -> dir.isDirectory() && name.startsWith("partition_"));
            if (partitions == null) continue;
            onDiskPartitions.addAll(Arrays.asList(partitions));
        }
        return onDiskPartitions;
    }

    public Path getPartitionRoot(int partition) throws HyracksDataException {
        Path path = Paths.get("storage", "partition_" + partition);
        FileReference resolve = this.ioManager.resolve(path.toString());
        return resolve.getFile().toPath();
    }

    public void deletePartition(int partitionId) {
        List<File> onDiskPartitions = this.getOnDiskPartitions();
        for (File onDiskPartition : onDiskPartitions) {
            int partitionNum = StoragePathUtil.getPartitionNumFromRelativePath((String)onDiskPartition.getAbsolutePath());
            if (partitionNum != partitionId) continue;
            LOGGER.warn("deleting partition {}", (Object)partitionNum);
            FileUtils.deleteQuietly((File)onDiskPartition);
            return;
        }
    }
}

