/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.input.stream.factory.LocalFSInputStreamFactory;
import org.apache.asterix.external.input.stream.factory.SocketServerInputStreamFactory;
import org.apache.asterix.external.provider.ParserFactoryProvider;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class DatasourceFactoryProvider {
    private static final String RESOURCE = "META-INF/services/org.apache.asterix.external.api.IRecordReaderFactory";
    private static Map<String, Class> factories = null;

    private DatasourceFactoryProvider() {
    }

    public static IExternalDataSourceFactory getExternalDataSourceFactory(Map<String, String> configuration) throws HyracksDataException, AsterixException {
        if (ExternalDataUtils.getDataSourceType(configuration).equals((Object)IExternalDataSourceFactory.DataSourceType.RECORDS)) {
            String reader = configuration.get("reader");
            return DatasourceFactoryProvider.getRecordReaderFactory(reader, configuration);
        }
        String streamSource = configuration.get("stream-source");
        return DatasourceFactoryProvider.getInputStreamFactory(streamSource, configuration);
    }

    public static IInputStreamFactory getInputStreamFactory(String streamSource, Map<String, String> configuration) throws HyracksDataException {
        IInputStreamFactory streamSourceFactory;
        if (ExternalDataUtils.isExternal(streamSource)) {
            throw new NotImplementedException();
        }
        switch (streamSource) {
            case "localfs": {
                streamSourceFactory = new LocalFSInputStreamFactory();
                break;
            }
            case "socket": 
            case "socket_adapter": {
                streamSourceFactory = new SocketServerInputStreamFactory();
                break;
            }
            case "socket-client": {
                streamSourceFactory = new SocketServerInputStreamFactory();
                break;
            }
            default: {
                try {
                    streamSourceFactory = (IInputStreamFactory)Class.forName(streamSource).newInstance();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeDataException(ErrorCode.PROVIDER_DATASOURCE_FACTORY_UNKNOWN_INPUT_STREAM_FACTORY, (Throwable)e, new Serializable[]{streamSource});
                }
            }
        }
        return streamSourceFactory;
    }

    protected static IRecordReaderFactory getInstance(Class clazz) throws AsterixException {
        try {
            return (IRecordReaderFactory)clazz.newInstance();
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException e) {
            throw new AsterixException("Cannot create: " + clazz.getSimpleName(), (Throwable)e);
        }
    }

    public static IRecordReaderFactory getRecordReaderFactory(String adaptorName, Map<String, String> configuration) throws HyracksDataException, AsterixException {
        if (adaptorName.equals("external")) {
            throw new NotImplementedException();
        }
        if (factories == null) {
            factories = DatasourceFactoryProvider.initFactories();
        }
        if (factories.containsKey(adaptorName)) {
            return DatasourceFactoryProvider.getInstance(factories.get(adaptorName));
        }
        try {
            return (IRecordReaderFactory)Class.forName(adaptorName).newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeDataException(ErrorCode.UNKNOWN_RECORD_READER_FACTORY, (Throwable)e, new Serializable[]{adaptorName});
        }
    }

    protected static Map<String, Class> initFactories() throws AsterixException {
        HashMap<String, Class> factories = new HashMap<String, Class>();
        ClassLoader cl = ParserFactoryProvider.class.getClassLoader();
        Charset encoding = Charset.forName("UTF-8");
        try {
            Enumeration<URL> urls = cl.getResources(RESOURCE);
            for (URL url : Collections.list(urls)) {
                String[] classNames;
                InputStream is = url.openStream();
                String config = IOUtils.toString((InputStream)is, (Charset)encoding);
                is.close();
                for (String className : classNames = config.split("\n")) {
                    if (className.startsWith("#")) continue;
                    Class<?> clazz = Class.forName(className);
                    List<String> formats = ((IRecordReaderFactory)clazz.newInstance()).getRecordReaderNames();
                    for (String format : formats) {
                        if (factories.containsKey(format)) {
                            throw new AsterixException(ErrorCode.PROVIDER_DATASOURCE_FACTORY_DUPLICATE_FORMAT_MAPPING, new Serializable[]{format});
                        }
                        factories.put(format, clazz);
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new AsterixException((Throwable)e);
        }
        return factories;
    }
}

