/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.tracing;

import com.azure.core.util.Context;
import com.azure.core.util.tracing.Tracer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

public final class TracerProxy {
    private static final List<Tracer> TRACERS;

    private TracerProxy() {
    }

    public static Context start(String methodName, Context context) {
        Context local = context;
        for (Tracer tracer : TRACERS) {
            local = tracer.start(methodName, local);
        }
        return local;
    }

    public static void setAttribute(String key, String value, Context context) {
        TRACERS.forEach(tracer -> tracer.setAttribute(key, value, context));
    }

    public static void end(int responseCode, Throwable error, Context context) {
        TRACERS.forEach(tracer -> tracer.end(responseCode, error, context));
    }

    public static Context setSpanName(String spanName, Context context) {
        Context local = context;
        for (Tracer tracer : TRACERS) {
            local = tracer.setSpanName(spanName, context);
        }
        return local;
    }

    static {
        ServiceLoader<Tracer> serviceLoader = ServiceLoader.load(Tracer.class);
        ArrayList<Tracer> tracers = new ArrayList<Tracer>();
        for (Tracer tracer : serviceLoader) {
            tracers.add(tracer);
        }
        TRACERS = Collections.unmodifiableList(tracers);
    }
}

