/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.HttpEngine;
import com.squareup.okhttp.internal.http.OkHeaders;
import com.squareup.okhttp.internal.http.RealResponseBody;
import com.squareup.okhttp.internal.http.RequestLine;
import com.squareup.okhttp.internal.http.RetryableSink;
import com.squareup.okhttp.internal.http.StatusLine;
import com.squareup.okhttp.internal.http.Transport;
import com.squareup.okhttp.internal.spdy.ErrorCode;
import com.squareup.okhttp.internal.spdy.Header;
import com.squareup.okhttp.internal.spdy.SpdyConnection;
import com.squareup.okhttp.internal.spdy.SpdyStream;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class SpdyTransport
implements Transport {
    private static final List<ByteString> SPDY_3_PROHIBITED_HEADERS = Util.immutableList(ByteString.encodeUtf8((String)"connection"), ByteString.encodeUtf8((String)"host"), ByteString.encodeUtf8((String)"keep-alive"), ByteString.encodeUtf8((String)"proxy-connection"), ByteString.encodeUtf8((String)"transfer-encoding"));
    private static final List<ByteString> HTTP_2_PROHIBITED_HEADERS = Util.immutableList(ByteString.encodeUtf8((String)"connection"), ByteString.encodeUtf8((String)"host"), ByteString.encodeUtf8((String)"keep-alive"), ByteString.encodeUtf8((String)"proxy-connection"), ByteString.encodeUtf8((String)"te"), ByteString.encodeUtf8((String)"transfer-encoding"), ByteString.encodeUtf8((String)"encoding"), ByteString.encodeUtf8((String)"upgrade"));
    private final HttpEngine httpEngine;
    private final SpdyConnection spdyConnection;
    private SpdyStream stream;

    public SpdyTransport(HttpEngine httpEngine, SpdyConnection spdyConnection) {
        this.httpEngine = httpEngine;
        this.spdyConnection = spdyConnection;
    }

    @Override
    public Sink createRequestBody(Request request, long contentLength) throws IOException {
        return this.stream.getSink();
    }

    @Override
    public void writeRequestHeaders(Request request) throws IOException {
        if (this.stream != null) {
            return;
        }
        this.httpEngine.writingRequestHeaders();
        boolean permitsRequestBody = this.httpEngine.permitsRequestBody();
        boolean hasResponseBody = true;
        String version = RequestLine.version(this.httpEngine.getConnection().getProtocol());
        this.stream = this.spdyConnection.newStream(SpdyTransport.writeNameValueBlock(request, this.spdyConnection.getProtocol(), version), permitsRequestBody, hasResponseBody);
        this.stream.readTimeout().timeout((long)this.httpEngine.client.getReadTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void writeRequestBody(RetryableSink requestBody) throws IOException {
        requestBody.writeToSocket(this.stream.getSink());
    }

    @Override
    public void finishRequest() throws IOException {
        this.stream.getSink().close();
    }

    @Override
    public Response.Builder readResponseHeaders() throws IOException {
        return SpdyTransport.readNameValueBlock(this.stream.getResponseHeaders(), this.spdyConnection.getProtocol());
    }

    public static List<Header> writeNameValueBlock(Request request, Protocol protocol, String version) {
        Headers headers = request.headers();
        ArrayList<Header> result = new ArrayList<Header>(headers.size() + 10);
        result.add(new Header(Header.TARGET_METHOD, request.method()));
        result.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(request.url())));
        String host = HttpEngine.hostHeader(request.url());
        if (Protocol.SPDY_3 == protocol) {
            result.add(new Header(Header.VERSION, version));
            result.add(new Header(Header.TARGET_HOST, host));
        } else if (Protocol.HTTP_2 == protocol) {
            result.add(new Header(Header.TARGET_AUTHORITY, host));
        } else {
            throw new AssertionError();
        }
        result.add(new Header(Header.TARGET_SCHEME, request.url().getProtocol()));
        LinkedHashSet<ByteString> names = new LinkedHashSet<ByteString>();
        int size = headers.size();
        block0: for (int i = 0; i < size; ++i) {
            ByteString name = ByteString.encodeUtf8((String)headers.name(i).toLowerCase(Locale.US));
            String value = headers.value(i);
            if (SpdyTransport.isProhibitedHeader(protocol, name) || name.equals((Object)Header.TARGET_METHOD) || name.equals((Object)Header.TARGET_PATH) || name.equals((Object)Header.TARGET_SCHEME) || name.equals((Object)Header.TARGET_AUTHORITY) || name.equals((Object)Header.TARGET_HOST) || name.equals((Object)Header.VERSION)) continue;
            if (names.add(name)) {
                result.add(new Header(name, value));
                continue;
            }
            for (int j = 0; j < result.size(); ++j) {
                if (!((Header)result.get((int)j)).name.equals((Object)name)) continue;
                String concatenated = SpdyTransport.joinOnNull(((Header)result.get((int)j)).value.utf8(), value);
                result.set(j, new Header(name, concatenated));
                continue block0;
            }
        }
        return result;
    }

    private static String joinOnNull(String first, String second) {
        return first + '\u0000' + second;
    }

    public static Response.Builder readNameValueBlock(List<Header> headerBlock, Protocol protocol) throws IOException {
        String status = null;
        String version = "HTTP/1.1";
        Headers.Builder headersBuilder = new Headers.Builder();
        headersBuilder.set(OkHeaders.SELECTED_PROTOCOL, protocol.toString());
        int size = headerBlock.size();
        for (int i = 0; i < size; ++i) {
            ByteString name = headerBlock.get((int)i).name;
            String values = headerBlock.get((int)i).value.utf8();
            int start = 0;
            while (start < values.length()) {
                int end = values.indexOf(0, start);
                if (end == -1) {
                    end = values.length();
                }
                String value = values.substring(start, end);
                if (name.equals((Object)Header.RESPONSE_STATUS)) {
                    status = value;
                } else if (name.equals((Object)Header.VERSION)) {
                    version = value;
                } else if (!SpdyTransport.isProhibitedHeader(protocol, name)) {
                    headersBuilder.add(name.utf8(), value);
                }
                start = end + 1;
            }
        }
        if (status == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        StatusLine statusLine = StatusLine.parse(version + " " + status);
        return new Response.Builder().protocol(protocol).code(statusLine.code).message(statusLine.message).headers(headersBuilder.build());
    }

    @Override
    public ResponseBody openResponseBody(Response response) throws IOException {
        return new RealResponseBody(response.headers(), Okio.buffer((Source)this.stream.getSource()));
    }

    @Override
    public void releaseConnectionOnIdle() {
    }

    @Override
    public void disconnect(HttpEngine engine) throws IOException {
        if (this.stream != null) {
            this.stream.close(ErrorCode.CANCEL);
        }
    }

    @Override
    public boolean canReuseConnection() {
        return true;
    }

    private static boolean isProhibitedHeader(Protocol protocol, ByteString name) {
        if (protocol == Protocol.SPDY_3) {
            return SPDY_3_PROHIBITED_HEADERS.contains(name);
        }
        if (protocol == Protocol.HTTP_2) {
            return HTTP_2_PROHIBITED_HEADERS.contains(name);
        }
        throw new AssertionError((Object)protocol);
    }
}

