/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.ExternalDataProjectionInfo;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.metadata.IProjectionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushFieldAccessToExternalDataScanRule
implements IAlgebraicRewriteRule {
    private final List<LogicalVariable> recordVariables = new ArrayList<LogicalVariable>();
    private final List<ExternalDataProjectionInfo> projectionInfos = new ArrayList<ExternalDataProjectionInfo>();
    private final Set<LogicalVariable> projectedVariables = new HashSet<LogicalVariable>();

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator currentOp = (ILogicalOperator)opRef.getValue();
        LogicalOperatorTag currentOpTag = currentOp.getOperatorTag();
        if (!context.getPhysicalOptimizationConfig().isExternalFieldPushdown()) {
            return false;
        }
        if (currentOpTag == LogicalOperatorTag.PROJECT) {
            ProjectOperator projectOp = (ProjectOperator)currentOp;
            this.projectedVariables.addAll(projectOp.getVariables());
            return false;
        }
        if (currentOpTag != LogicalOperatorTag.DATASOURCESCAN) {
            return false;
        }
        return this.setDatasetProperties(currentOp, (MetadataProvider)context.getMetadataProvider());
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (!context.getPhysicalOptimizationConfig().isExternalFieldPushdown() || context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, op) || this.projectionInfos.isEmpty()) {
            return false;
        }
        if (op.getOperatorTag() != LogicalOperatorTag.SELECT && op.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        if (op.getOperatorTag() == LogicalOperatorTag.SELECT) {
            SelectOperator selectOp = (SelectOperator)op;
            this.pushFieldAccessExpression((Mutable<ILogicalExpression>)selectOp.getCondition(), context);
        } else {
            AssignOperator assignOp = (AssignOperator)op;
            this.pushFieldAccessExpression(assignOp.getExpressions(), context);
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, op);
        return false;
    }

    private void pushFieldAccessExpression(List<Mutable<ILogicalExpression>> exprList, IOptimizationContext context) throws AlgebricksException {
        for (Mutable<ILogicalExpression> exprRef : exprList) {
            this.pushFieldAccessExpression(exprRef, context);
        }
    }

    private void pushFieldAccessExpression(Mutable<ILogicalExpression> exprRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        if (!PushFieldAccessToExternalDataScanRule.isFieldAccessByName((ILogicalExpression)funcExpr)) {
            this.pushFieldAccessExpression(funcExpr.getArguments(), context);
            return;
        }
        LogicalVariable funcRootInputVar = PushFieldAccessToExternalDataScanRule.getRootExpressionInputVariable(funcExpr);
        if (funcRootInputVar != null) {
            int recordVarIndex = this.recordVariables.indexOf(funcRootInputVar);
            if (recordVarIndex >= 0) {
                List projectedFieldNames = this.projectionInfos.get(recordVarIndex).getProjectionInfo();
                ArrayList<String> fieldNames = new ArrayList<String>();
                PushFieldAccessToExternalDataScanRule.buildFieldNames((ILogicalExpression)funcExpr, fieldNames);
                if (!fieldNames.isEmpty()) {
                    projectedFieldNames.add(fieldNames);
                }
            }
        } else {
            this.pushFieldAccessExpression(funcExpr.getArguments(), context);
        }
    }

    private boolean setDatasetProperties(ILogicalOperator op, MetadataProvider mp) throws AlgebricksException {
        String datasetName;
        DataSourceScanOperator scan = (DataSourceScanOperator)op;
        DataSource dataSource = (DataSource)scan.getDataSource();
        if (dataSource == null) {
            return false;
        }
        DataverseName dataverse = dataSource.getId().getDataverseName();
        Dataset dataset = mp.findDataset(dataverse, datasetName = dataSource.getId().getDatasourceName());
        if (dataset == null || dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL || dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL && !ExternalDataUtils.supportsPushdown((Map)((ExternalDatasetDetails)dataset.getDatasetDetails()).getProperties())) {
            return false;
        }
        boolean changed = false;
        DatasetDataSource datasetDataSource = (DatasetDataSource)dataSource;
        LogicalVariable recordVar = datasetDataSource.getDataRecordVariable(scan.getVariables());
        if (!this.projectedVariables.contains(recordVar) && scan.getProjectionInfo() == null) {
            this.recordVariables.add(recordVar);
            ExternalDataProjectionInfo projectionInfo = new ExternalDataProjectionInfo();
            scan.setProjectionInfo((IProjectionInfo)projectionInfo);
            this.projectionInfos.add(projectionInfo);
            changed = true;
        }
        return changed;
    }

    private static LogicalVariable getRootExpressionInputVariable(AbstractFunctionCallExpression funcExpr) {
        ILogicalExpression currentExpr = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
        while (PushFieldAccessToExternalDataScanRule.isFieldAccessByName(currentExpr)) {
            currentExpr = (ILogicalExpression)((Mutable)((AbstractFunctionCallExpression)currentExpr).getArguments().get(0)).getValue();
        }
        if (currentExpr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            return ((VariableReferenceExpression)currentExpr).getVariableReference();
        }
        return null;
    }

    private static boolean isFieldAccessByName(ILogicalExpression expression) {
        return expression.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && BuiltinFunctions.FIELD_ACCESS_BY_NAME.equals((Object)((AbstractFunctionCallExpression)expression).getFunctionIdentifier());
    }

    private static void buildFieldNames(ILogicalExpression expr, List<String> fieldNames) throws CompilationException {
        if (!PushFieldAccessToExternalDataScanRule.isFieldAccessByName(expr)) {
            return;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        ILogicalExpression objectExpr = (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue();
        if (!PushFieldAccessToExternalDataScanRule.isPayload(objectExpr)) {
            PushFieldAccessToExternalDataScanRule.buildFieldNames(objectExpr, fieldNames);
        }
        fieldNames.add(ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)funcExpr, (int)1));
    }

    private static boolean isPayload(ILogicalExpression expr) {
        return expr.getExpressionTag() == LogicalExpressionTag.VARIABLE;
    }
}

