/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.kv.subdoc.multi;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.endpoint.ResponseStatusConverter;
import com.couchbase.client.core.endpoint.kv.KeyValueStatus;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.AbstractKeyValueResponse;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.core.message.kv.subdoc.BinarySubdocMultiMutationRequest;
import com.couchbase.client.core.message.kv.subdoc.multi.MultiResult;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.List;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class MultiMutationResponse
extends AbstractKeyValueResponse {
    private final long cas;
    private final MutationToken mutationToken;
    private final List<MultiResult<Mutation>> responses;
    private final int firstErrorIndex;
    private final ResponseStatus firstErrorStatus;

    public MultiMutationResponse(ResponseStatus status, short serverStatusCode, String bucket, int firstErrorIndex, short firstErrorStatusCode, BinarySubdocMultiMutationRequest request, long cas, MutationToken mutationToken) {
        super(status, serverStatusCode, bucket, Unpooled.EMPTY_BUFFER, request);
        this.cas = cas;
        this.mutationToken = mutationToken;
        this.firstErrorIndex = firstErrorIndex;
        this.firstErrorStatus = firstErrorIndex == -1 ? ResponseStatus.FAILURE : ResponseStatusConverter.fromBinary(firstErrorStatusCode);
        this.responses = Collections.emptyList();
    }

    public MultiMutationResponse(ResponseStatus status, short serverStatusCode, String bucket, BinarySubdocMultiMutationRequest request, long cas, MutationToken mutationToken) {
        super(status, serverStatusCode, bucket, Unpooled.EMPTY_BUFFER, request);
        this.cas = cas;
        this.mutationToken = mutationToken;
        this.firstErrorIndex = -1;
        this.firstErrorStatus = ResponseStatus.FAILURE;
        this.responses = Collections.emptyList();
    }

    public MultiMutationResponse(String bucket, BinarySubdocMultiMutationRequest request, long cas, MutationToken token, List<MultiResult<Mutation>> responses) {
        super(ResponseStatus.SUCCESS, KeyValueStatus.SUCCESS.code(), bucket, Unpooled.EMPTY_BUFFER, request);
        this.cas = cas;
        this.mutationToken = token;
        this.firstErrorIndex = -1;
        this.firstErrorStatus = ResponseStatus.SUCCESS;
        this.responses = responses;
    }

    @Override
    public BinarySubdocMultiMutationRequest request() {
        return (BinarySubdocMultiMutationRequest)super.request();
    }

    public long cas() {
        return this.cas;
    }

    public MutationToken mutationToken() {
        return this.mutationToken;
    }

    public int firstErrorIndex() {
        return this.firstErrorIndex;
    }

    public ResponseStatus firstErrorStatus() {
        return this.firstErrorStatus;
    }

    public List<MultiResult<Mutation>> responses() {
        return this.responses;
    }
}

