/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.visitor.SqlppFormatPrintVisitor;

public class SqlppFormatPrintUtil {
    private SqlppFormatPrintUtil() {
    }

    public static void print(ILangExpression expr, PrintWriter output) throws CompilationException {
        SqlppFormatPrintVisitor visitor = new SqlppFormatPrintVisitor(output);
        expr.accept((ILangVisitor)visitor, (Object)0);
    }

    public static void print(List<Statement> statements, PrintWriter output) throws CompilationException {
        SqlppFormatPrintVisitor visitor = new SqlppFormatPrintVisitor(output);
        for (Statement statement : statements) {
            statement.accept((ILangVisitor)visitor, (Object)0);
        }
    }

    public static String toString(ILangExpression expr) throws CompilationException {
        ArrayList<ILangExpression> exprs = new ArrayList<ILangExpression>();
        exprs.add(expr);
        return SqlppFormatPrintUtil.toString(exprs);
    }

    public static String toString(List<ILangExpression> exprs) throws CompilationException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter output = new PrintWriter(bos);
        SqlppFormatPrintVisitor visitor = new SqlppFormatPrintVisitor(output);
        for (ILangExpression expr : exprs) {
            expr.accept((ILangVisitor)visitor, (Object)0);
        }
        output.close();
        return bos.toString();
    }
}

